/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Equal;
import fj.F;
import fj.Function;
import fj.Hash;
import fj.Monoid;
import fj.Show;
import fj.data.List;
import fj.data.Natural$$Lambda$1;
import fj.data.Natural$$Lambda$10;
import fj.data.Natural$$Lambda$2;
import fj.data.Natural$$Lambda$3;
import fj.data.Natural$$Lambda$4;
import fj.data.Natural$$Lambda$5;
import fj.data.Natural$$Lambda$6;
import fj.data.Natural$$Lambda$7;
import fj.data.Natural$$Lambda$8;
import fj.data.Natural$$Lambda$9;
import fj.data.Option;
import fj.data.Stream;
import fj.data.vector.V;
import fj.data.vector.V2;
import java.math.BigInteger;

public final class Natural
extends Number {
    private final BigInteger value;
    private static final long serialVersionUID = -588673650944359682L;
    public static final F<BigInteger, Option<Natural>> fromBigInt = Natural$$Lambda$3.lambdaFactory$();
    public static final Natural ZERO = Natural.natural(0L).some();
    public static final Natural ONE = Natural.natural(1L).some();
    public static final F<Natural, F<Natural, Natural>> add = Function.curry(Natural$$Lambda$4.lambdaFactory$());
    public static final F<Natural, F<Natural, Option<Natural>>> subtract = Function.curry(Natural$$Lambda$5.lambdaFactory$());
    public static final F<Natural, F<Natural, Natural>> multiply = Function.curry(Natural$$Lambda$6.lambdaFactory$());
    public static final F<Natural, F<Natural, Natural>> divide = Function.curry(Natural$$Lambda$7.lambdaFactory$());
    public static final F<Natural, F<Natural, Natural>> mod = Function.curry(Natural$$Lambda$8.lambdaFactory$());
    public static final F<Natural, F<Natural, V2<Natural>>> divmod = Function.curry(Natural$$Lambda$9.lambdaFactory$());
    public static final F<Natural, BigInteger> bigIntegerValue = Natural$$Lambda$10.lambdaFactory$();

    private Natural(BigInteger i) {
        if (i.compareTo(BigInteger.ZERO) < 0) {
            throw Bottom.error("Natural less than zero");
        }
        this.value = i;
    }

    public static Option<Natural> natural(BigInteger i) {
        return i.compareTo(BigInteger.ZERO) < 0 ? Option.none() : Option.some(new Natural(i));
    }

    public static Option<Natural> natural(long i) {
        return Natural.natural(BigInteger.valueOf(i));
    }

    public Natural succ() {
        return this.add(ONE);
    }

    public static F<Natural, Natural> succ_() {
        return Natural$$Lambda$1.lambdaFactory$();
    }

    public Option<Natural> pred() {
        return this.subtract(ONE);
    }

    public static F<Natural, Option<Natural>> pred_() {
        return Natural$$Lambda$2.lambdaFactory$();
    }

    public Natural add(Natural n) {
        return Natural.natural(n.value.add(this.value)).some();
    }

    public Option<Natural> subtract(Natural n) {
        return Natural.natural(this.value.subtract(n.value));
    }

    public Natural multiply(Natural n) {
        return Natural.natural(n.value.multiply(this.value)).some();
    }

    public Natural divide(Natural n) {
        return Natural.natural(this.value.divide(n.value)).some();
    }

    public Natural mod(Natural n) {
        return Natural.natural(this.value.mod(n.value)).some();
    }

    public V2<Natural> divmod(Natural n) {
        BigInteger[] x = this.value.divideAndRemainder(n.value);
        return V.v(Natural.natural(x[0]).some(), Natural.natural(x[1]).some());
    }

    public BigInteger bigIntegerValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    public static Natural sum(Stream<Natural> ns) {
        return Monoid.naturalAdditionMonoid.sumLeft(ns);
    }

    public static Natural product(Stream<Natural> ns) {
        return Monoid.naturalMultiplicationMonoid.sumLeft(ns);
    }

    public static Natural sum(List<Natural> ns) {
        return Monoid.naturalAdditionMonoid.sumLeft(ns);
    }

    public static Natural product(List<Natural> ns) {
        return Monoid.naturalMultiplicationMonoid.sumLeft(ns);
    }

    public int hashCode() {
        return Hash.naturalHash.hash(this);
    }

    public boolean equals(Object that) {
        return Equal.equals0(Natural.class, this, that, Equal.naturalEqual);
    }

    public String toString() {
        return Show.naturalShow.showS(this);
    }

    static /* synthetic */ V2 lambda$static$3(Natural n1, Natural n2) {
        return n2.divmod(n1);
    }

    static /* synthetic */ Natural lambda$static$2(Natural n1, Natural n2) {
        return n2.mod(n1);
    }

    static /* synthetic */ Natural lambda$static$1(Natural n1, Natural n2) {
        return n2.divide(n1);
    }

    static /* synthetic */ Option lambda$static$0(Natural o, Natural o1) {
        return o1.subtract(o);
    }
}

