/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Equal;
import fj.Hash;
import fj.Unit;
import fj.data.Array;
import fj.data.HashMap;
import fj.data.HashSet$$Lambda$1;
import fj.data.HashSet$$Lambda$2;
import fj.data.List;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public final class HashSet<A>
implements Iterable<A> {
    private final HashMap<A, Unit> m;

    @Override
    public Iterator<A> iterator() {
        return this.toCollection().iterator();
    }

    public HashSet(Equal<A> e, Hash<A> h) {
        this.m = new HashMap(e, h);
    }

    public HashSet(Equal<A> e, Hash<A> h, int initialCapacity) {
        this.m = new HashMap(e, h, initialCapacity);
    }

    public HashSet(Equal<A> e, Hash<A> h, int initialCapacity, float loadFactor) {
        this.m = new HashMap(e, h, initialCapacity, loadFactor);
    }

    public boolean eq(A a1, A a2) {
        return this.m.eq(a1, a2);
    }

    public int hash(A a) {
        return this.m.hash(a);
    }

    public static <A> HashSet<A> empty(Equal<A> e, Hash<A> h) {
        return new HashSet<A>(e, h);
    }

    public static <A> HashSet<A> empty() {
        return HashSet.empty(Equal.anyEqual(), Hash.anyHash());
    }

    public static <A> HashSet<A> iterableHashSet(Iterable<A> it) {
        return HashSet.iterableHashSet(Equal.anyEqual(), Hash.anyHash(), it);
    }

    public static <A> HashSet<A> iterableHashSet(Equal<A> e, Hash<A> h, Iterable<A> it) {
        HashSet<A> hs = HashSet.empty(e, h);
        for (A a : it) {
            hs.set(a);
        }
        return hs;
    }

    public static <A> HashSet<A> iteratorHashSet(Iterator<A> it) {
        return HashSet.iterableHashSet(HashSet$$Lambda$1.lambdaFactory$(it));
    }

    public static <A> HashSet<A> iteratorHashSet(Equal<A> e, Hash<A> h, Iterator<A> it) {
        return HashSet.iterableHashSet(e, h, HashSet$$Lambda$2.lambdaFactory$(it));
    }

    @SafeVarargs
    public static <A> HashSet<A> arrayHashSet(A ... as) {
        return HashSet.iterableHashSet(Array.array(as));
    }

    @SafeVarargs
    public static <A> HashSet<A> arrayHashSet(Equal<A> e, Hash<A> h, A ... as) {
        return HashSet.iterableHashSet(e, h, Array.array(as));
    }

    @SafeVarargs
    public static <A> HashSet<A> hashSet(A ... as) {
        return HashSet.arrayHashSet(as);
    }

    @SafeVarargs
    public static <A> HashSet<A> hashSet(Equal<A> e, Hash<A> h, A ... as) {
        return HashSet.arrayHashSet(e, h, as);
    }

    public boolean contains(A a) {
        return this.m.contains(a);
    }

    public void set(A a) {
        this.m.set(a, Unit.unit());
    }

    public void clear() {
        this.m.clear();
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public int size() {
        return this.m.size();
    }

    public boolean delete(A a) {
        return this.m.getDelete(a).isSome();
    }

    public List<A> toList() {
        return this.m.keys();
    }

    public java.util.List<A> toJavaList() {
        return this.toList().toJavaList();
    }

    public Set<A> toJavaSet() {
        return new java.util.HashSet<A>(this.toCollection());
    }

    public static <A> HashSet<A> fromSet(Set<A> s) {
        return HashSet.iterableHashSet(s);
    }

    public Collection<A> toCollection() {
        return this.toList().toCollection();
    }

    static /* synthetic */ Iterator lambda$iteratorHashSet$1(Iterator it) {
        return it;
    }

    static /* synthetic */ Iterator lambda$iteratorHashSet$0(Iterator it) {
        return it;
    }
}

