/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.Equal;
import fj.F;
import fj.F0;
import fj.Function;
import fj.Hash;
import fj.P;
import fj.P1;
import fj.Show;
import fj.Unit;
import fj.data.Array;
import fj.data.Either$$Lambda$1;
import fj.data.Either$$Lambda$10;
import fj.data.Either$$Lambda$11;
import fj.data.Either$$Lambda$12;
import fj.data.Either$$Lambda$13;
import fj.data.Either$$Lambda$14;
import fj.data.Either$$Lambda$2;
import fj.data.Either$$Lambda$3;
import fj.data.Either$$Lambda$4;
import fj.data.Either$$Lambda$5;
import fj.data.Either$$Lambda$6;
import fj.data.Either$$Lambda$7;
import fj.data.Either$$Lambda$8;
import fj.data.Either$$Lambda$9;
import fj.data.Either$LeftProjection$$Lambda$1;
import fj.data.Either$LeftProjection$$Lambda$2;
import fj.data.Either$LeftProjection$$Lambda$3;
import fj.data.Either$RightProjection$$Lambda$1;
import fj.data.Either$RightProjection$$Lambda$2;
import fj.data.Either$RightProjection$$Lambda$3;
import fj.data.IO;
import fj.data.IOFunctions;
import fj.data.List;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Effect1;
import java.util.Collection;
import java.util.Iterator;

public abstract class Either<A, B> {
    private Either() {
    }

    public final LeftProjection<A, B> left() {
        return new LeftProjection(this);
    }

    public final RightProjection<A, B> right() {
        return new RightProjection(this);
    }

    public abstract boolean isLeft();

    public abstract boolean isRight();

    public abstract <X> X either(F<A, X> var1, F<B, X> var2);

    public final <X, Y> Either<X, Y> bimap(F<A, X> left, F<B, Y> right) {
        return this.either(Function.compose(Either.<A, Either<A, B>>left_(), left), Function.compose(Either.<B, Either<A, B>>right_(), right));
    }

    public final boolean equals(Object other) {
        return Equal.equals0(Either.class, this, other, Either$$Lambda$1.lambdaFactory$());
    }

    public final int hashCode() {
        return Hash.eitherHash(Hash.anyHash(), Hash.anyHash()).hash(this);
    }

    public final Either<B, A> swap() {
        return this.either(Either.<B, Either<A, B>>right_(), Either.<A, Either<A, B>>left_());
    }

    public static <A, B> Either<A, B> left(A a) {
        return new Left(a);
    }

    public static <A, B> F<A, Either<A, B>> left_() {
        return Either$$Lambda$2.lambdaFactory$();
    }

    public static <A, B> F<B, Either<A, B>> right_() {
        return Either$$Lambda$3.lambdaFactory$();
    }

    public static <A, B> Either<A, B> right(B b) {
        return new Right(b);
    }

    public static <A, B, X> F<Either<A, B>, X> either_(F<A, X> left, F<B, X> right) {
        return Either$$Lambda$4.lambdaFactory$(left, right);
    }

    public static <A, B, X> F<F<A, X>, F<Either<A, B>, Either<X, B>>> leftMap_() {
        return Either$$Lambda$5.lambdaFactory$();
    }

    public static <A, B, X> F<F<B, X>, F<Either<A, B>, Either<A, X>>> rightMap_() {
        return Either$$Lambda$6.lambdaFactory$();
    }

    public static <A, B> Either<A, B> joinLeft(Either<Either<A, B>, B> e) {
        return e.left().bind(Function.identity());
    }

    public static <A, B> Either<A, B> joinRight(Either<A, Either<A, B>> e) {
        return e.right().bind(Function.identity());
    }

    public static <A, X> Either<List<A>, X> sequenceLeft(List<Either<A, X>> a) {
        return a.isEmpty() ? Either.left(List.nil()) : a.head().left().bind(Either$$Lambda$7.lambdaFactory$(a));
    }

    public static <B, X> Either<X, List<B>> sequenceRight(List<Either<X, B>> a) {
        return a.isEmpty() ? Either.right(List.nil()) : a.head().right().bind(Either$$Lambda$8.lambdaFactory$(a));
    }

    public final <C> List<Either<A, C>> traverseListRight(F<B, List<C>> f) {
        return this.right().traverseList(f);
    }

    public final <C> List<Either<C, B>> traverseListLeft(F<A, List<C>> f) {
        return this.left().traverseList(f);
    }

    public final <C> IO<Either<A, C>> traverseIORight(F<B, IO<C>> f) {
        return this.right().traverseIO(f);
    }

    public final <C> IO<Either<C, B>> traverseIOLeft(F<A, IO<C>> f) {
        return this.left().traverseIO(f);
    }

    public final <C> Option<Either<A, C>> traverseOptionRight(F<B, Option<C>> f) {
        return this.right().traverseOption(f);
    }

    public final <C> Option<Either<C, B>> traverseOptionLeft(F<A, Option<C>> f) {
        return this.left().traverseOption(f);
    }

    public final <C> Stream<Either<A, C>> traverseStreamRight(F<B, Stream<C>> f) {
        return this.right().traverseStream(f);
    }

    public final <C> Stream<Either<C, B>> traverseStreamLeft(F<A, Stream<C>> f) {
        return this.left().traverseStream(f);
    }

    public static <A> A reduce(Either<A, A> e) {
        return e.either(Function.identity(), Function.identity());
    }

    public static <A, B> Either<A, B> iif(boolean c, F0<B> right, F0<A> left) {
        return c ? new Right(right.f()) : new Left(left.f());
    }

    public static <A, B> List<A> lefts(List<Either<A, B>> es) {
        return es.foldRight(Either$$Lambda$9.lambdaFactory$(), List.nil());
    }

    public static <A, B> List<B> rights(List<Either<A, B>> es) {
        return es.foldRight(Either$$Lambda$10.lambdaFactory$(), List.nil());
    }

    public final String toString() {
        return Show.eitherShow(Show.anyShow(), Show.anyShow()).showS(this);
    }

    static /* synthetic */ F lambda$rights$11(Either e) {
        return Either$$Lambda$11.lambdaFactory$(e);
    }

    static /* synthetic */ List lambda$null$10(Either e, List bs) {
        return e.isRight() ? bs.cons(e.right().value()) : bs;
    }

    static /* synthetic */ F lambda$lefts$9(Either e) {
        return Either$$Lambda$12.lambdaFactory$(e);
    }

    static /* synthetic */ List lambda$null$8(Either e, List as) {
        return e.isLeft() ? as.cons(e.left().value()) : as;
    }

    static /* synthetic */ Either lambda$sequenceRight$7(List a, Object bb) {
        return Either.sequenceRight(a.tail()).right().map(List.cons_(bb));
    }

    static /* synthetic */ Either lambda$sequenceLeft$6(List a, Object aa) {
        return Either.sequenceLeft(a.tail()).left().map(List.cons_(aa));
    }

    static /* synthetic */ F lambda$rightMap_$5(F axf) {
        return Either$$Lambda$13.lambdaFactory$(axf);
    }

    static /* synthetic */ Either lambda$null$4(F axf, Either e) {
        return e.right().map(axf);
    }

    static /* synthetic */ F lambda$leftMap_$3(F axf) {
        return Either$$Lambda$14.lambdaFactory$(axf);
    }

    static /* synthetic */ Either lambda$null$2(F axf, Either e) {
        return e.left().map(axf);
    }

    static /* synthetic */ Object lambda$either_$1(F left, F right, Either e) {
        return e.either(left, right);
    }

    static /* synthetic */ Equal lambda$equals$0() {
        return Equal.eitherEqual(Equal.anyEqual(), Equal.anyEqual());
    }

    public static final class RightProjection<A, B>
    implements Iterable<B> {
        private final Either<A, B> e;

        private RightProjection(Either<A, B> e) {
            this.e = e;
        }

        @Override
        public Iterator<B> iterator() {
            return this.toCollection().iterator();
        }

        public Either<A, B> either() {
            return this.e;
        }

        public B valueE(F0<String> err) {
            if (this.e.isRight()) {
                return (B)((Right)this.e).b;
            }
            throw Bottom.error(err.f());
        }

        public B value() {
            return this.valueE(P.p("right.value on Left"));
        }

        public B orValue(F0<B> b) {
            return this.e.isRight() ? this.value() : b.f();
        }

        public B on(F<A, B> f) {
            return this.e.isRight() ? this.value() : f.f(this.e.left().value());
        }

        public Unit foreach(F<B, Unit> f) {
            if (this.e.isRight()) {
                f.f(this.value());
            }
            return Unit.unit();
        }

        public void foreachDoEffect(Effect1<B> f) {
            if (this.e.isRight()) {
                f.f(this.value());
            }
        }

        public <X> Either<A, X> map(F<B, X> f) {
            return this.e.isRight() ? new Right(f.f(this.value())) : new Left(this.e.left().value());
        }

        public <X> Either<A, X> bind(F<B, Either<A, X>> f) {
            return this.e.isRight() ? f.f(this.value()) : new Left(this.e.left().value());
        }

        public <X> Either<A, X> sequence(Either<A, X> e) {
            return this.bind(Function.constant(e));
        }

        public <C> List<Either<A, C>> traverseList(F<B, List<C>> f) {
            return this.e.isRight() ? f.f(this.value()).map(Either.right_()) : List.list(Either.left(this.e.left().value()));
        }

        public <C> IO<Either<A, C>> traverseIO(F<B, IO<C>> f) {
            return this.e.isRight() ? IOFunctions.map(f.f(this.value()), Either.right_()) : IOFunctions.lazy(Either$RightProjection$$Lambda$1.lambdaFactory$(this));
        }

        public <C> P1<Either<A, C>> traverseP1(F<B, P1<C>> f) {
            return this.e.isRight() ? f.f(this.value()).map(Either.right_()) : P.p(Either.left(this.e.left().value()));
        }

        public <C> Option<Either<A, C>> traverseOption(F<B, Option<C>> f) {
            return this.e.isRight() ? f.f(this.value()).map(Either.right_()) : Option.some(Either.left(this.e.left().value()));
        }

        public <X> Option<Either<X, B>> filter(F<B, Boolean> f) {
            return this.e.isRight() ? (f.f(this.value()).booleanValue() ? Option.some(new Right(this.value())) : Option.none()) : Option.none();
        }

        public <X> Either<A, X> apply(Either<A, F<B, X>> e) {
            return e.right().bind(Either$RightProjection$$Lambda$2.lambdaFactory$(this));
        }

        public boolean forall(F<B, Boolean> f) {
            return this.e.isLeft() || f.f(this.value()) != false;
        }

        public boolean exists(F<B, Boolean> f) {
            return this.e.isRight() && f.f(this.value()) != false;
        }

        public List<B> toList() {
            return this.e.isRight() ? List.single(this.value()) : List.nil();
        }

        public Option<B> toOption() {
            return this.e.isRight() ? Option.some(this.value()) : Option.none();
        }

        public Array<B> toArray() {
            if (this.e.isRight()) {
                Object[] a = new Object[]{this.value()};
                return Array.mkArray(a);
            }
            return Array.empty();
        }

        public Stream<B> toStream() {
            return this.e.isRight() ? Stream.single(this.value()) : Stream.nil();
        }

        public Collection<B> toCollection() {
            return this.toList().toCollection();
        }

        public <C> Stream<Either<A, C>> traverseStream(F<B, Stream<C>> f) {
            return this.e.isRight() ? f.f(this.value()).map(Either$RightProjection$$Lambda$3.lambdaFactory$()) : Stream.single(Either.left(this.e.left().value()));
        }

        static /* synthetic */ Either lambda$traverseIO$0(RightProjection this_) {
            return Either.left(this_.e.left().value());
        }
    }

    public static final class LeftProjection<A, B>
    implements Iterable<A> {
        private final Either<A, B> e;

        private LeftProjection(Either<A, B> e) {
            this.e = e;
        }

        @Override
        public Iterator<A> iterator() {
            return this.toCollection().iterator();
        }

        public Either<A, B> either() {
            return this.e;
        }

        public A valueE(F0<String> err) {
            if (this.e.isLeft()) {
                return (A)((Left)this.e).a;
            }
            throw Bottom.error(err.f());
        }

        public A valueE(String err) {
            return this.valueE(P.p(err));
        }

        public A value() {
            return this.valueE(P.p("left.value on Right"));
        }

        public A orValue(F0<A> a) {
            return this.e.isLeft() ? this.value() : a.f();
        }

        public A orValue(A a) {
            return this.e.isLeft() ? this.value() : a;
        }

        public A on(F<B, A> f) {
            return this.e.isLeft() ? this.value() : f.f(this.e.right().value());
        }

        public Unit foreach(F<A, Unit> f) {
            if (this.e.isLeft()) {
                f.f(this.value());
            }
            return Unit.unit();
        }

        public void foreachDoEffect(Effect1<A> f) {
            if (this.e.isLeft()) {
                f.f(this.value());
            }
        }

        public <X> Either<X, B> map(F<A, X> f) {
            return this.e.isLeft() ? new Left(f.f(this.value())) : new Right(this.e.right().value());
        }

        public <X> Either<X, B> bind(F<A, Either<X, B>> f) {
            return this.e.isLeft() ? f.f(this.value()) : new Right(this.e.right().value());
        }

        public <X> Either<X, B> sequence(Either<X, B> e) {
            return this.bind(Function.constant(e));
        }

        public <C> List<Either<C, B>> traverseList(F<A, List<C>> f) {
            return this.e.isLeft() ? f.f(this.value()).map(Either$LeftProjection$$Lambda$1.lambdaFactory$()) : List.list(Either.right(this.e.right().value()));
        }

        public <C> IO<Either<C, B>> traverseIO(F<A, IO<C>> f) {
            return this.e.isLeft() ? IOFunctions.map(f.f(this.value()), Either$LeftProjection$$Lambda$2.lambdaFactory$()) : IOFunctions.unit(Either.right(this.e.right().value()));
        }

        public <X> Option<Either<A, X>> filter(F<A, Boolean> f) {
            return this.e.isLeft() ? (f.f(this.value()).booleanValue() ? Option.some(new Left(this.value())) : Option.none()) : Option.none();
        }

        public <X> Either<X, B> apply(Either<F<A, X>, B> e) {
            return e.left().bind(Either$LeftProjection$$Lambda$3.lambdaFactory$(this));
        }

        public boolean forall(F<A, Boolean> f) {
            return this.e.isRight() || f.f(this.value()) != false;
        }

        public boolean exists(F<A, Boolean> f) {
            return this.e.isLeft() && f.f(this.value()) != false;
        }

        public List<A> toList() {
            return this.e.isLeft() ? List.single(this.value()) : List.nil();
        }

        public Option<A> toOption() {
            return this.e.isLeft() ? Option.some(this.value()) : Option.none();
        }

        public Array<A> toArray() {
            if (this.e.isLeft()) {
                Object[] a = new Object[]{this.value()};
                return Array.mkArray(a);
            }
            return Array.mkArray(new Object[0]);
        }

        public Stream<A> toStream() {
            return this.e.isLeft() ? Stream.single(this.value()) : Stream.nil();
        }

        public Collection<A> toCollection() {
            return this.toList().toCollection();
        }

        public <C> Option<Either<C, B>> traverseOption(F<A, Option<C>> f) {
            return this.e.isLeft() ? f.f(this.value()).map(Either.left_()) : Option.some(Either.right(this.e.right().value()));
        }

        public <C> Stream<Either<C, B>> traverseStream(F<A, Stream<C>> f) {
            return this.e.isLeft() ? f.f(this.value()).map(Either.left_()) : Stream.single(Either.right(this.e.right().value()));
        }
    }

    private static final class Right<A, B>
    extends Either<A, B> {
        private final B b;

        Right(B b) {
            this.b = b;
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }

        @Override
        public <X> X either(F<A, X> left, F<B, X> right) {
            return right.f(this.b);
        }
    }

    private static final class Left<A, B>
    extends Either<A, B> {
        private final A a;

        Left(A a) {
            this.a = a;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }

        @Override
        public <X> X either(F<A, X> left, F<B, X> right) {
            return left.f(this.a);
        }
    }
}

