/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.exception.FlywaySqlException;

public class JdbcUtils {
    private static final Log LOG = LogFactory.getLog(JdbcUtils.class);

    private JdbcUtils() {
    }

    public static Connection openConnection(DataSource dataSource) throws FlywayException {
        try {
            Connection connection = dataSource.getConnection();
            if (connection == null) {
                throw new FlywayException("Unable to obtain database connection");
            }
            return connection;
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to obtain database connection", e);
        }
    }

    public static void closeConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            LOG.error("Error while closing database connection: " + e.getMessage(), e);
        }
    }

    public static void closeStatement(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            LOG.error("Error while closing JDBC statement", e);
        }
    }

    public static void closeResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException e) {
            LOG.error("Error while closing JDBC resultSet", e);
        }
    }
}

