/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.informix;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.SqlScript;
import org.flywaydb.core.internal.database.informix.InformixConnection;
import org.flywaydb.core.internal.database.informix.InformixSqlScript;
import org.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;
import org.flywaydb.core.internal.util.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.LoadableResource;
import org.flywaydb.core.internal.util.scanner.StringResource;

public class InformixDatabase
extends Database<InformixConnection> {
    public InformixDatabase(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
    }

    @Override
    protected InformixConnection getConnection(Connection connection) {
        return new InformixConnection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    protected final void ensureSupported() {
        String version = this.majorVersion + "." + this.minorVersion;
        if (this.majorVersion < 12 || this.majorVersion == 12 && this.minorVersion < 10) {
            throw new FlywayDbUpgradeRequiredException("Informix", version, "12.10");
        }
        if (this.majorVersion == 12 && this.minorVersion > 10 || this.majorVersion > 12) {
            this.recommendFlywayUpgrade("Informix", version);
        }
    }

    @Override
    protected SqlScript doCreateSqlScript(LoadableResource resource, PlaceholderReplacer placeholderReplacer, boolean mixed) {
        return new InformixSqlScript(this.configuration, resource, mixed, placeholderReplacer);
    }

    @Override
    public LoadableResource getRawCreateScript() {
        return new StringResource("CREATE TABLE ${table} (\n    installed_rank INT NOT NULL,\n    version VARCHAR(50),\n    description VARCHAR(200) NOT NULL,\n    type VARCHAR(20) NOT NULL,\n    script LVARCHAR(1000) NOT NULL,\n    checksum INT,\n    installed_by VARCHAR(100) NOT NULL,\n    installed_on DATETIME YEAR TO FRACTION(3) DEFAULT CURRENT YEAR TO FRACTION(3) NOT NULL,\n    execution_time INT NOT NULL,\n    success SMALLINT NOT NULL\n);\nALTER TABLE ${table} ADD CONSTRAINT CHECK (success in (0,1)) CONSTRAINT ${table}_s;\nALTER TABLE ${table} ADD CONSTRAINT PRIMARY KEY (installed_rank) CONSTRAINT ${table}_pk;\nCREATE INDEX ${table}_s_idx ON ${table} (success);");
    }

    @Override
    public String getDbName() {
        return "informix";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return this.getJdbcMetaData().getUserName();
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    protected boolean supportsChangingCurrentSchema() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "t";
    }

    @Override
    public String getBooleanFalse() {
        return "f";
    }

    @Override
    public String doQuote(String identifier) {
        return identifier;
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return false;
    }
}

