/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.form;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.flowable.engine.form.AbstractFormType;

public class BooleanFormType
extends AbstractFormType {
    private static final long serialVersionUID = 1L;

    public String getName() {
        return "boolean";
    }

    public String getMimeType() {
        return "plain/text";
    }

    public Object convertFormValueToModelValue(String propertyValue) {
        if (propertyValue == null || "".equals(propertyValue)) {
            return null;
        }
        return Boolean.valueOf(propertyValue);
    }

    public String convertModelValueToFormValue(Object modelValue) {
        if (modelValue == null) {
            return null;
        }
        if (Boolean.class.isAssignableFrom(modelValue.getClass()) || Boolean.TYPE.isAssignableFrom(modelValue.getClass())) {
            return modelValue.toString();
        }
        throw new ActivitiIllegalArgumentException("Model value is not of type boolean, but of type " + modelValue.getClass().getName());
    }
}

