/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.event;

import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.helper.ScopeUtil;
import org.activiti.engine.impl.event.EventHandler;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;

public class CompensationEventHandler
implements EventHandler {
    public static final String EVENT_HANDLER_TYPE = "compensate";

    @Override
    public String getEventHandlerType() {
        return EVENT_HANDLER_TYPE;
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        String configuration = eventSubscription.getConfiguration();
        if (configuration == null) {
            throw new ActivitiException("Compensating execution not set for compensate event subscription with id " + eventSubscription.getId());
        }
        ExecutionEntity compensatingExecution = commandContext.getExecutionEntityManager().findExecutionById(configuration);
        ActivityImpl compensationHandler = eventSubscription.getActivity();
        if ((compensationHandler.getProperty("isForCompensation") == null || !((Boolean)compensationHandler.getProperty("isForCompensation")).booleanValue()) && compensationHandler.isScope()) {
            List<CompensateEventSubscriptionEntity> eventsForThisScope = compensatingExecution.getCompensateEventSubscriptions();
            ScopeUtil.throwCompensationEvent(eventsForThisScope, compensatingExecution, false);
        } else {
            try {
                if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                    commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)ActivitiEventBuilder.createActivityEvent(FlowableEngineEventType.ACTIVITY_COMPENSATE, compensationHandler.getId(), (String)compensationHandler.getProperty("name"), compensatingExecution.getId(), compensatingExecution.getProcessInstanceId(), compensatingExecution.getProcessDefinitionId(), (String)compensatingExecution.getActivity().getProperties().get("type"), compensatingExecution.getActivity().getActivityBehavior().getClass().getCanonicalName()));
                }
                compensatingExecution.setActivity(compensationHandler);
                compensatingExecution.performOperation(AtomicOperation.ACTIVITY_START);
            }
            catch (Exception e) {
                throw new ActivitiException("Error while handling compensation event " + eventSubscription, e);
            }
        }
    }
}

