/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockExclusiveJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LockExclusiveJobCmd.class);
    protected JobEntity job;

    public LockExclusiveJobCmd(JobEntity job) {
        this.job = job;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        ExecutionEntity execution;
        if (this.job == null) {
            throw new ActivitiIllegalArgumentException("job is null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing lock exclusive job {} {}", (Object)this.job.getId(), (Object)this.job.getExecutionId());
        }
        if (this.job.isExclusive() && this.job.getExecutionId() != null && (execution = commandContext.getExecutionEntityManager().findExecutionById(this.job.getExecutionId())) != null) {
            commandContext.getExecutionEntityManager().updateProcessInstanceLockTime(execution.getProcessInstanceId());
        }
        return null;
    }
}

