/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.ScriptTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptTaskParseHandler
extends AbstractActivityBpmnParseHandler<ScriptTask> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptTaskParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return ScriptTask.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, ScriptTask scriptTask) {
        if (StringUtils.isEmpty((CharSequence)scriptTask.getScript())) {
            LOGGER.warn("No script provided for scriptTask {}", (Object)scriptTask.getId());
        }
        ActivityImpl activity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)scriptTask, "scriptTask");
        activity.setAsync(scriptTask.isAsynchronous());
        activity.setExclusive(!scriptTask.isNotExclusive());
        activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createScriptTaskActivityBehavior(scriptTask));
    }
}

