/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.ThrowEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateThrowEventParseHandler
extends AbstractActivityBpmnParseHandler<ThrowEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntermediateThrowEventParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return ThrowEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, ThrowEvent intermediateEvent) {
        ActivityImpl nestedActivityImpl = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)intermediateEvent, "intermediateThrowEvent");
        EventDefinition eventDefinition = null;
        if (!intermediateEvent.getEventDefinitions().isEmpty()) {
            eventDefinition = (EventDefinition)intermediateEvent.getEventDefinitions().get(0);
        }
        nestedActivityImpl.setAsync(intermediateEvent.isAsynchronous());
        nestedActivityImpl.setExclusive(!intermediateEvent.isNotExclusive());
        if (eventDefinition instanceof SignalEventDefinition) {
            bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, (BaseElement)eventDefinition);
        } else if (eventDefinition instanceof CompensateEventDefinition) {
            bpmnParse.getBpmnParserHandlers().parseElement(bpmnParse, (BaseElement)eventDefinition);
        } else if (eventDefinition == null) {
            nestedActivityImpl.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createIntermediateThrowNoneEventActivityBehavior(intermediateEvent));
        } else {
            LOGGER.warn("Unsupported intermediate throw event type for throw event {}", (Object)intermediateEvent.getId());
        }
    }
}

