/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.bpmn.parser.BpmnParseHandlers;
import org.activiti.engine.impl.bpmn.parser.BpmnParser;
import org.activiti.engine.impl.bpmn.parser.factory.ActivityBehaviorFactory;
import org.activiti.engine.impl.bpmn.parser.factory.ListenerFactory;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.HasDIBounds;
import org.activiti.engine.impl.pvm.process.Lane;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.impl.util.ReflectUtil;
import org.activiti.engine.impl.util.io.ResourceStreamSource;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.exceptions.XMLException;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.Import;
import org.flowable.bpmn.model.Interface;
import org.flowable.bpmn.model.ItemDefinition;
import org.flowable.bpmn.model.Message;
import org.flowable.bpmn.model.Operation;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.common.engine.api.io.InputStreamProvider;
import org.flowable.common.engine.impl.event.FlowableEventSupport;
import org.flowable.common.engine.impl.util.io.InputStreamSource;
import org.flowable.common.engine.impl.util.io.StreamSource;
import org.flowable.common.engine.impl.util.io.StringStreamSource;
import org.flowable.common.engine.impl.util.io.UrlStreamSource;
import org.flowable.engine.impl.bpmn.data.ClassStructureDefinition;
import org.flowable.engine.impl.bpmn.data.ItemKind;
import org.flowable.engine.impl.bpmn.data.StructureDefinition;
import org.flowable.engine.impl.bpmn.parser.XMLImporter;
import org.flowable.engine.impl.bpmn.webservice.BpmnInterface;
import org.flowable.engine.impl.bpmn.webservice.BpmnInterfaceImplementation;
import org.flowable.engine.impl.bpmn.webservice.MessageDefinition;
import org.flowable.engine.impl.bpmn.webservice.OperationImplementation;
import org.flowable.validation.ProcessValidator;
import org.flowable.validation.ValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnParse
implements BpmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BpmnParse.class);
    public static final String PROPERTYNAME_INITIAL = "initial";
    public static final String PROPERTYNAME_INITIATOR_VARIABLE_NAME = "initiatorVariableName";
    public static final String PROPERTYNAME_CONDITION = "condition";
    public static final String PROPERTYNAME_CONDITION_TEXT = "conditionText";
    public static final String PROPERTYNAME_TIMER_DECLARATION = "timerDeclarations";
    public static final String PROPERTYNAME_ISEXPANDED = "isExpanded";
    public static final String PROPERTYNAME_START_TIMER = "timerStart";
    public static final String PROPERTYNAME_COMPENSATION_HANDLER_ID = "compensationHandler";
    public static final String PROPERTYNAME_IS_FOR_COMPENSATION = "isForCompensation";
    public static final String PROPERTYNAME_ERROR_EVENT_DEFINITIONS = "errorEventDefinitions";
    public static final String PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION = "eventDefinitions";
    protected String name;
    protected boolean validateSchema = true;
    protected boolean validateProcess = true;
    protected StreamSource streamSource;
    protected String sourceSystemId;
    protected BpmnModel bpmnModel;
    protected String targetNamespace;
    protected DeploymentEntity deployment;
    protected List<ProcessDefinitionEntity> processDefinitions = new ArrayList<ProcessDefinitionEntity>();
    protected Map<String, TransitionImpl> sequenceFlows;
    protected BpmnParseHandlers bpmnParserHandlers;
    protected ProcessDefinitionEntity currentProcessDefinition;
    protected FlowElement currentFlowElement;
    protected ActivityImpl currentActivity;
    protected LinkedList<SubProcess> currentSubprocessStack = new LinkedList();
    protected LinkedList<ScopeImpl> currentScopeStack = new LinkedList();
    protected Map<String, MessageDefinition> messages = new HashMap<String, MessageDefinition>();
    protected Map<String, StructureDefinition> structures = new HashMap<String, StructureDefinition>();
    protected Map<String, BpmnInterfaceImplementation> interfaceImplementations = new HashMap<String, BpmnInterfaceImplementation>();
    protected Map<String, OperationImplementation> operationImplementations = new HashMap<String, OperationImplementation>();
    protected Map<String, org.flowable.engine.impl.bpmn.data.ItemDefinition> itemDefinitions = new HashMap<String, org.flowable.engine.impl.bpmn.data.ItemDefinition>();
    protected Map<String, BpmnInterface> bpmnInterfaces = new HashMap<String, BpmnInterface>();
    protected Map<String, org.flowable.engine.impl.bpmn.webservice.Operation> operations = new HashMap<String, org.flowable.engine.impl.bpmn.webservice.Operation>();
    protected Map<String, XMLImporter> importers = new HashMap<String, XMLImporter>();
    protected Map<String, String> prefixs = new HashMap<String, String>();
    protected ExpressionManager expressionManager;
    protected ActivityBehaviorFactory activityBehaviorFactory;
    protected ListenerFactory listenerFactory;

    public BpmnParse(BpmnParser parser) {
        this.expressionManager = parser.getExpressionManager();
        this.activityBehaviorFactory = parser.getActivityBehaviorFactory();
        this.listenerFactory = parser.getListenerFactory();
        this.bpmnParserHandlers = parser.getBpmnParserHandlers();
        this.initializeXSDItemDefinitions();
    }

    protected void initializeXSDItemDefinitions() {
        this.itemDefinitions.put("http://www.w3.org/2001/XMLSchema:string", new org.flowable.engine.impl.bpmn.data.ItemDefinition("http://www.w3.org/2001/XMLSchema:string", (StructureDefinition)new ClassStructureDefinition(String.class)));
    }

    public BpmnParse deployment(DeploymentEntity deployment) {
        this.deployment = deployment;
        return this;
    }

    public BpmnParse execute() {
        try {
            ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
            BpmnXMLConverter converter = new BpmnXMLConverter();
            boolean enableSafeBpmnXml = false;
            String encoding = null;
            if (processEngineConfiguration != null) {
                enableSafeBpmnXml = processEngineConfiguration.isEnableSafeBpmnXml();
                encoding = processEngineConfiguration.getXmlEncoding();
            }
            this.bpmnModel = encoding != null ? converter.convertToBpmnModel((InputStreamProvider)this.streamSource, this.validateSchema, enableSafeBpmnXml, encoding) : converter.convertToBpmnModel((InputStreamProvider)this.streamSource, this.validateSchema, enableSafeBpmnXml);
            if (this.validateProcess) {
                ProcessValidator processValidator = processEngineConfiguration.getProcessValidator();
                if (processValidator == null) {
                    LOGGER.warn("Process should be validated, but no process validator is configured on the process engine configuration!");
                } else {
                    List validationErrors = processValidator.validate(this.bpmnModel);
                    if (validationErrors != null && !validationErrors.isEmpty()) {
                        StringBuilder warningBuilder = new StringBuilder();
                        StringBuilder errorBuilder = new StringBuilder();
                        for (ValidationError error : validationErrors) {
                            if (error.isWarning()) {
                                warningBuilder.append(error.toString());
                                warningBuilder.append("\n");
                                continue;
                            }
                            errorBuilder.append(error.toString());
                            errorBuilder.append("\n");
                        }
                        if (errorBuilder.length() > 0) {
                            throw new ActivitiException("Errors while parsing:\n" + errorBuilder);
                        }
                        if (warningBuilder.length() > 0) {
                            LOGGER.warn("Following warnings encountered during process validation: {}", (Object)warningBuilder.toString());
                        }
                    }
                }
            }
            this.bpmnModel.setEventSupport((Object)new FlowableEventSupport());
            this.createImports();
            this.createItemDefinitions();
            this.createMessages();
            this.createOperations();
            this.transformProcessDefinitions();
        }
        catch (Exception e) {
            if (e instanceof ActivitiException) {
                throw (ActivitiException)e;
            }
            if (e instanceof XMLException) {
                throw (XMLException)e;
            }
            throw new ActivitiException("Error parsing XML", e);
        }
        return this;
    }

    public BpmnParse name(String name) {
        this.name = name;
        return this;
    }

    public BpmnParse sourceInputStream(InputStream inputStream) {
        if (this.name == null) {
            this.name("inputStream");
        }
        this.setStreamSource((StreamSource)new InputStreamSource(inputStream));
        return this;
    }

    public BpmnParse sourceResource(String resource) {
        return this.sourceResource(resource, null);
    }

    public BpmnParse sourceUrl(URL url) {
        if (this.name == null) {
            this.name(url.toString());
        }
        this.setStreamSource((StreamSource)new UrlStreamSource(url));
        return this;
    }

    public BpmnParse sourceUrl(String url) {
        try {
            return this.sourceUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new ActivitiIllegalArgumentException("malformed url: " + url, e);
        }
    }

    public BpmnParse sourceResource(String resource, ClassLoader classLoader) {
        if (this.name == null) {
            this.name(resource);
        }
        this.setStreamSource(new ResourceStreamSource(resource, classLoader));
        return this;
    }

    public BpmnParse sourceString(String string) {
        if (this.name == null) {
            this.name("string");
        }
        this.setStreamSource((StreamSource)new StringStreamSource(string));
        return this;
    }

    protected void setStreamSource(StreamSource streamSource) {
        if (this.streamSource != null) {
            throw new ActivitiIllegalArgumentException("invalid: multiple sources " + this.streamSource + " and " + streamSource);
        }
        this.streamSource = streamSource;
    }

    protected void createImports() {
        for (Import theImport : this.bpmnModel.getImports()) {
            XMLImporter importer = this.getImporter(theImport);
            if (importer == null) {
                throw new ActivitiException("Could not import item of type " + theImport.getImportType());
            }
            importer.importFrom(theImport, this.sourceSystemId);
            this.structures.putAll(importer.getStructures());
            this.interfaceImplementations.putAll(importer.getServices());
            this.operationImplementations.putAll(importer.getOperations());
        }
    }

    protected XMLImporter getImporter(Import theImport) {
        if (this.importers.containsKey(theImport.getImportType())) {
            return this.importers.get(theImport.getImportType());
        }
        if (theImport.getImportType().equals("http://schemas.xmlsoap.org/wsdl/")) {
            try {
                Class<?> wsdlImporterClass = Class.forName("org.flowable.engine.impl.webservice.CxfWSDLImporter", true, Thread.currentThread().getContextClassLoader());
                XMLImporter newInstance = (XMLImporter)wsdlImporterClass.newInstance();
                this.importers.put(theImport.getImportType(), newInstance);
                return newInstance;
            }
            catch (Exception e) {
                throw new ActivitiException("Could not find importer for type " + theImport.getImportType());
            }
        }
        return null;
    }

    public void createMessages() {
        for (Message messageElement : this.bpmnModel.getMessages()) {
            MessageDefinition messageDefinition = new MessageDefinition(messageElement.getId());
            if (StringUtils.isNotEmpty((CharSequence)messageElement.getItemRef()) && this.itemDefinitions.containsKey(messageElement.getItemRef())) {
                org.flowable.engine.impl.bpmn.data.ItemDefinition itemDefinition = this.itemDefinitions.get(messageElement.getItemRef());
                messageDefinition.setItemDefinition(itemDefinition);
            }
            this.messages.put(messageDefinition.getId(), messageDefinition);
        }
    }

    protected void createItemDefinitions() {
        for (ItemDefinition itemDefinitionElement : this.bpmnModel.getItemDefinitions().values()) {
            ClassStructureDefinition structure = null;
            try {
                Class<?> classStructure = ReflectUtil.loadClass(itemDefinitionElement.getStructureRef());
                structure = new ClassStructureDefinition(classStructure);
            }
            catch (ActivitiException e) {
                structure = this.structures.get(itemDefinitionElement.getStructureRef());
            }
            org.flowable.engine.impl.bpmn.data.ItemDefinition itemDefinition = new org.flowable.engine.impl.bpmn.data.ItemDefinition(itemDefinitionElement.getId(), (StructureDefinition)structure);
            if (StringUtils.isNotEmpty((CharSequence)itemDefinitionElement.getItemKind())) {
                itemDefinition.setItemKind(ItemKind.valueOf((String)itemDefinitionElement.getItemKind()));
            }
            this.itemDefinitions.put(itemDefinition.getId(), itemDefinition);
        }
    }

    protected void createOperations() {
        for (Interface interfaceObject : this.bpmnModel.getInterfaces()) {
            BpmnInterface bpmnInterface = new BpmnInterface(interfaceObject.getId(), interfaceObject.getName());
            bpmnInterface.setImplementation(this.interfaceImplementations.get(interfaceObject.getImplementationRef()));
            for (Operation operationObject : interfaceObject.getOperations()) {
                if (!this.messages.containsKey(operationObject.getInMessageRef())) continue;
                MessageDefinition inMessage = this.messages.get(operationObject.getInMessageRef());
                org.flowable.engine.impl.bpmn.webservice.Operation operation = new org.flowable.engine.impl.bpmn.webservice.Operation(operationObject.getId(), operationObject.getName(), bpmnInterface, inMessage);
                operation.setImplementation(this.operationImplementations.get(operationObject.getImplementationRef()));
                if (StringUtils.isNotEmpty((CharSequence)operationObject.getOutMessageRef()) && this.messages.containsKey(operationObject.getOutMessageRef())) {
                    MessageDefinition outMessage = this.messages.get(operationObject.getOutMessageRef());
                    operation.setOutMessage(outMessage);
                }
                this.operations.put(operation.getId(), operation);
            }
        }
    }

    protected void transformProcessDefinitions() {
        this.sequenceFlows = new HashMap<String, TransitionImpl>();
        for (Process process : this.bpmnModel.getProcesses()) {
            if (!process.isExecutable()) continue;
            this.bpmnParserHandlers.parseElement(this, (BaseElement)process);
        }
        if (!this.processDefinitions.isEmpty()) {
            this.processDI();
        }
    }

    public void processFlowElements(Collection<FlowElement> flowElements) {
        ArrayList<SequenceFlow> sequenceFlowToParse = new ArrayList<SequenceFlow>();
        ArrayList<BoundaryEvent> boundaryEventsToParse = new ArrayList<BoundaryEvent>();
        ArrayList<FlowElement> defferedFlowElementsToParse = new ArrayList<FlowElement>();
        for (FlowElement flowElement : flowElements) {
            if (flowElement instanceof SequenceFlow) {
                sequenceFlowToParse.add((SequenceFlow)flowElement);
                continue;
            }
            if (flowElement instanceof BoundaryEvent) {
                boundaryEventsToParse.add((BoundaryEvent)flowElement);
                continue;
            }
            if (flowElement instanceof Event) {
                defferedFlowElementsToParse.add(flowElement);
                continue;
            }
            this.bpmnParserHandlers.parseElement(this, (BaseElement)flowElement);
        }
        for (FlowElement flowElement : defferedFlowElementsToParse) {
            this.bpmnParserHandlers.parseElement(this, (BaseElement)flowElement);
        }
        for (BoundaryEvent boundaryEvent : boundaryEventsToParse) {
            this.bpmnParserHandlers.parseElement(this, (BaseElement)boundaryEvent);
        }
        for (SequenceFlow sequenceFlow : sequenceFlowToParse) {
            this.bpmnParserHandlers.parseElement(this, (BaseElement)sequenceFlow);
        }
    }

    public void processDI() {
        if (!this.bpmnModel.getLocationMap().isEmpty()) {
            for (String bpmnReference : this.bpmnModel.getLocationMap().keySet()) {
                if (this.bpmnModel.getFlowElement(bpmnReference) == null) {
                    if (this.bpmnModel.getArtifact(bpmnReference) != null || this.bpmnModel.getPool(bpmnReference) != null || this.bpmnModel.getLane(bpmnReference) != null) continue;
                    LOGGER.warn("Invalid reference in diagram interchange definition: could not find {}", (Object)bpmnReference);
                    continue;
                }
                if (this.bpmnModel.getFlowElement(bpmnReference) instanceof FlowNode) continue;
                LOGGER.warn("Invalid reference in diagram interchange definition: {} does not reference a flow node", (Object)bpmnReference);
            }
            for (String bpmnReference : this.bpmnModel.getFlowLocationMap().keySet()) {
                if (this.bpmnModel.getFlowElement(bpmnReference) == null) {
                    if (this.bpmnModel.getArtifact(bpmnReference) != null) continue;
                    LOGGER.warn("Invalid reference in diagram interchange definition: could not find {}", (Object)bpmnReference);
                    continue;
                }
                if (this.bpmnModel.getFlowElement(bpmnReference) instanceof SequenceFlow) continue;
                LOGGER.warn("Invalid reference in diagram interchange definition: {} does not reference a sequence flow", (Object)bpmnReference);
            }
            for (Process process : this.bpmnModel.getProcesses()) {
                ProcessDefinitionEntity processDefinition;
                if (!process.isExecutable() || (processDefinition = this.getProcessDefinition(process.getId())) == null) continue;
                processDefinition.setGraphicalNotationDefined(true);
                for (String shapeId : this.bpmnModel.getLocationMap().keySet()) {
                    if (processDefinition.findActivity(shapeId) == null) continue;
                    this.createBPMNShape(shapeId, this.bpmnModel.getGraphicInfo(shapeId), processDefinition);
                }
                for (String edgeId : this.bpmnModel.getFlowLocationMap().keySet()) {
                    if (this.bpmnModel.getFlowElement(edgeId) == null) continue;
                    this.createBPMNEdge(edgeId, this.bpmnModel.getFlowLocationGraphicInfo(edgeId));
                }
            }
        }
    }

    public void createBPMNShape(String key, GraphicInfo graphicInfo, ProcessDefinitionEntity processDefinition) {
        ActivityImpl activity = processDefinition.findActivity(key);
        if (activity != null) {
            this.createDIBounds(graphicInfo, activity);
        } else {
            Lane lane = processDefinition.getLaneForId(key);
            if (lane != null) {
                this.createDIBounds(graphicInfo, lane);
            }
        }
    }

    protected void createDIBounds(GraphicInfo graphicInfo, HasDIBounds target) {
        target.setX((int)graphicInfo.getX());
        target.setY((int)graphicInfo.getY());
        target.setWidth((int)graphicInfo.getWidth());
        target.setHeight((int)graphicInfo.getHeight());
    }

    public void createBPMNEdge(String key, List<GraphicInfo> graphicList) {
        FlowElement flowElement = this.bpmnModel.getFlowElement(key);
        if (flowElement != null && this.sequenceFlows.containsKey(key)) {
            TransitionImpl sequenceFlow = this.sequenceFlows.get(key);
            ArrayList<Integer> waypoints = new ArrayList<Integer>();
            for (GraphicInfo waypointInfo : graphicList) {
                waypoints.add((int)waypointInfo.getX());
                waypoints.add((int)waypointInfo.getY());
            }
            sequenceFlow.setWaypoints(waypoints);
        } else if (this.bpmnModel.getArtifact(key) == null) {
            LOGGER.warn("Invalid reference in 'bpmnElement' attribute, sequenceFlow {} not found", (Object)key);
        }
    }

    public ProcessDefinitionEntity getProcessDefinition(String processDefinitionKey) {
        for (ProcessDefinitionEntity processDefinition : this.processDefinitions) {
            if (!processDefinition.getKey().equals(processDefinitionKey)) continue;
            return processDefinition;
        }
        return null;
    }

    public boolean isValidateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    public boolean isValidateProcess() {
        return this.validateProcess;
    }

    public void setValidateProcess(boolean validateProcess) {
        this.validateProcess = validateProcess;
    }

    public List<ProcessDefinitionEntity> getProcessDefinitions() {
        return this.processDefinitions;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public BpmnParseHandlers getBpmnParserHandlers() {
        return this.bpmnParserHandlers;
    }

    public void setBpmnParserHandlers(BpmnParseHandlers bpmnParserHandlers) {
        this.bpmnParserHandlers = bpmnParserHandlers;
    }

    public DeploymentEntity getDeployment() {
        return this.deployment;
    }

    public void setDeployment(DeploymentEntity deployment) {
        this.deployment = deployment;
    }

    public BpmnModel getBpmnModel() {
        return this.bpmnModel;
    }

    public void setBpmnModel(BpmnModel bpmnModel) {
        this.bpmnModel = bpmnModel;
    }

    public ActivityBehaviorFactory getActivityBehaviorFactory() {
        return this.activityBehaviorFactory;
    }

    public void setActivityBehaviorFactory(ActivityBehaviorFactory activityBehaviorFactory) {
        this.activityBehaviorFactory = activityBehaviorFactory;
    }

    public ListenerFactory getListenerFactory() {
        return this.listenerFactory;
    }

    public void setListenerFactory(ListenerFactory listenerFactory) {
        this.listenerFactory = listenerFactory;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    public Map<String, TransitionImpl> getSequenceFlows() {
        return this.sequenceFlows;
    }

    public Map<String, MessageDefinition> getMessages() {
        return this.messages;
    }

    public Map<String, BpmnInterfaceImplementation> getInterfaceImplementations() {
        return this.interfaceImplementations;
    }

    public Map<String, org.flowable.engine.impl.bpmn.data.ItemDefinition> getItemDefinitions() {
        return this.itemDefinitions;
    }

    public Map<String, XMLImporter> getImporters() {
        return this.importers;
    }

    public Map<String, org.flowable.engine.impl.bpmn.webservice.Operation> getOperations() {
        return this.operations;
    }

    public void setOperations(Map<String, org.flowable.engine.impl.bpmn.webservice.Operation> operations) {
        this.operations = operations;
    }

    public ProcessDefinitionEntity getCurrentProcessDefinition() {
        return this.currentProcessDefinition;
    }

    public void setCurrentProcessDefinition(ProcessDefinitionEntity currentProcessDefinition) {
        this.currentProcessDefinition = currentProcessDefinition;
    }

    public FlowElement getCurrentFlowElement() {
        return this.currentFlowElement;
    }

    public void setCurrentFlowElement(FlowElement currentFlowElement) {
        this.currentFlowElement = currentFlowElement;
    }

    public ActivityImpl getCurrentActivity() {
        return this.currentActivity;
    }

    public void setCurrentActivity(ActivityImpl currentActivity) {
        this.currentActivity = currentActivity;
    }

    public void setCurrentSubProcess(SubProcess subProcess) {
        this.currentSubprocessStack.push(subProcess);
    }

    public SubProcess getCurrentSubProcess() {
        return this.currentSubprocessStack.peek();
    }

    public void removeCurrentSubProcess() {
        this.currentSubprocessStack.pop();
    }

    public void setCurrentScope(ScopeImpl scope) {
        this.currentScopeStack.push(scope);
    }

    public ScopeImpl getCurrentScope() {
        return this.currentScopeStack.peek();
    }

    public void removeCurrentScope() {
        this.currentScopeStack.pop();
    }

    public BpmnParse setSourceSystemId(String systemId) {
        this.sourceSystemId = systemId;
        return this;
    }

    public String getSourceSystemId() {
        return this.sourceSystemId;
    }
}

