package org.activiti.engine.impl;

import java.util.List;
import java.util.Map;

import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.task.NativeTaskQuery;
import org.activiti.engine.task.Task;

public class NativeTaskQueryImpl extends AbstractNativeQuery<NativeTaskQuery, Task> implements NativeTaskQuery {

    private static final long serialVersionUID = 1L;

    public NativeTaskQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public NativeTaskQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    // results ////////////////////////////////////////////////////////////////

    @Override
    public List<Task> executeList(CommandContext commandContext, Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return commandContext
                .getTaskEntityManager()
                .findTasksByNativeQuery(parameterMap, firstResult, maxResults);
    }

    @Override
    public long executeCount(CommandContext commandContext, Map<String, Object> parameterMap) {
        return commandContext
                .getTaskEntityManager()
                .findTaskCountByNativeQuery(parameterMap);
    }

}
