/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class StringType
implements VariableType {
    public static final String TYPE_NAME = "string";
    private final int maxLength;

    public StringType(int maxLength) {
        this.maxLength = maxLength;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return true;
    }

    public Object getValue(ValueFields valueFields) {
        return valueFields.getTextValue();
    }

    public void setValue(Object value, ValueFields valueFields) {
        valueFields.setTextValue((String)value);
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            String stringValue = (String)value;
            return stringValue.length() <= this.maxLength;
        }
        return false;
    }
}

