/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.ui.task.model.runtime.TaskRepresentation;
import org.flowable.ui.task.service.runtime.FlowableTaskActionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class TaskActionResource {
    @Autowired
    protected FlowableTaskActionService taskActionService;

    @RequestMapping(value={"/rest/tasks/{taskId}/action/complete"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    public void completeTask(@PathVariable String taskId) {
        this.taskActionService.completeTask(taskId);
    }

    @RequestMapping(value={"/rest/tasks/{taskId}/action/assign"}, method={RequestMethod.PUT})
    public TaskRepresentation assignTask(@PathVariable String taskId, @RequestBody ObjectNode requestNode) {
        return this.taskActionService.assignTask(taskId, requestNode);
    }

    @RequestMapping(value={"/rest/tasks/{taskId}/action/involve"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void involveUser(@PathVariable(value="taskId") String taskId, @RequestBody ObjectNode requestNode) {
        this.taskActionService.involveUser(taskId, requestNode);
    }

    @RequestMapping(value={"/rest/tasks/{taskId}/action/remove-involved"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public void removeInvolvedUser(@PathVariable(value="taskId") String taskId, @RequestBody ObjectNode requestNode) {
        this.taskActionService.removeInvolvedUser(taskId, requestNode);
    }

    @RequestMapping(value={"/rest/tasks/{taskId}/action/claim"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    public void claimTask(@PathVariable String taskId) {
        this.taskActionService.claimTask(taskId);
    }
}

