/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Artifact;
import org.flowable.bpmn.model.Association;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.Lane;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Pool;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.TextAnnotation;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.engine.HistoryService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.idm.api.User;
import org.flowable.job.api.Job;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.common.service.exception.NotPermittedException;
import org.flowable.ui.task.model.debugger.BreakpointRepresentation;
import org.flowable.ui.task.service.debugger.DebuggerService;
import org.flowable.ui.task.service.editor.mapper.EventInfoMapper;
import org.flowable.ui.task.service.editor.mapper.InfoMapper;
import org.flowable.ui.task.service.editor.mapper.ReceiveTaskInfoMapper;
import org.flowable.ui.task.service.editor.mapper.SequenceFlowInfoMapper;
import org.flowable.ui.task.service.editor.mapper.ServiceTaskInfoMapper;
import org.flowable.ui.task.service.editor.mapper.UserTaskInfoMapper;
import org.flowable.ui.task.service.runtime.PermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class RuntimeDisplayJsonClientResource {
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected ManagementService managementService;
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected DebuggerService debuggerService;
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected List<String> eventElementTypes = new ArrayList<String>();
    protected Map<String, InfoMapper> propertyMappers = new HashMap<String, InfoMapper>();

    public RuntimeDisplayJsonClientResource() {
        this.eventElementTypes.add("StartEvent");
        this.eventElementTypes.add("EndEvent");
        this.eventElementTypes.add("BoundaryEvent");
        this.eventElementTypes.add("IntermediateCatchEvent");
        this.eventElementTypes.add("ThrowEvent");
        this.propertyMappers.put("BoundaryEvent", (InfoMapper)new EventInfoMapper());
        this.propertyMappers.put("EndEvent", (InfoMapper)new EventInfoMapper());
        this.propertyMappers.put("IntermediateCatchEvent", (InfoMapper)new EventInfoMapper());
        this.propertyMappers.put("ReceiveTask", (InfoMapper)new ReceiveTaskInfoMapper());
        this.propertyMappers.put("StartEvent", (InfoMapper)new EventInfoMapper());
        this.propertyMappers.put("SequenceFlow", (InfoMapper)new SequenceFlowInfoMapper());
        this.propertyMappers.put("ServiceTask", (InfoMapper)new ServiceTaskInfoMapper());
        this.propertyMappers.put("ThrowEvent", (InfoMapper)new EventInfoMapper());
        this.propertyMappers.put("UserTask", (InfoMapper)new UserTaskInfoMapper());
    }

    @RequestMapping(value={"/rest/process-instances/debugger/{processInstanceId}/model-json"}, method={RequestMethod.GET}, produces={"application/json"})
    public JsonNode getDebuggerModelJSON(@PathVariable String processInstanceId) {
        if (this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).count() > 0L) {
            return this.getModelJSON(processInstanceId);
        }
        return this.getModelHistoryJSON(processInstanceId);
    }

    @RequestMapping(value={"/rest/process-instances/{processInstanceId}/model-json"}, method={RequestMethod.GET}, produces={"application/json"})
    public JsonNode getModelJSON(@PathVariable String processInstanceId) {
        List jobs;
        User currentUser = SecurityUtils.getCurrentUserObject();
        if (!this.permissionService.hasReadPermissionOnProcessInstance(currentUser, processInstanceId)) {
            throw new NotPermittedException();
        }
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new BadRequestException("No process instance found with id " + processInstanceId);
        }
        BpmnModel pojoModel = this.repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
        if (pojoModel == null || pojoModel.getLocationMap().isEmpty()) {
            throw new InternalServerErrorException("Process definition could not be found with id " + processInstance.getProcessDefinitionId());
        }
        List activityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
        HashSet<String> completedActivityInstances = new HashSet<String>();
        HashSet<String> currentElements = new HashSet<String>();
        if (CollectionUtils.isNotEmpty((Collection)activityInstances)) {
            for (HistoricActivityInstance activityInstance : activityInstances) {
                if (activityInstance.getEndTime() != null) {
                    completedActivityInstances.add(activityInstance.getActivityId());
                    continue;
                }
                currentElements.add(activityInstance.getActivityId());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(jobs = this.managementService.createJobQuery().processInstanceId(processInstanceId).list()))) {
            List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
            HashMap<String, Execution> executionMap = new HashMap<String, Execution>();
            for (Execution execution : executions) {
                executionMap.put(execution.getId(), execution);
            }
            for (Job job : jobs) {
                if (!executionMap.containsKey(job.getExecutionId())) continue;
                currentElements.add(((Execution)executionMap.get(job.getExecutionId())).getActivityId());
            }
        }
        List<String> completedFlows = this.gatherCompletedFlows(completedActivityInstances, currentElements, pojoModel);
        HashSet<String> completedElements = new HashSet<String>(completedActivityInstances);
        completedElements.addAll(completedFlows);
        ArrayList<String> breakpoints = new ArrayList<String>();
        for (BreakpointRepresentation breakpoint : this.debuggerService.getBreakpoints()) {
            breakpoints.add(breakpoint.getActivityId());
        }
        ObjectNode displayNode = this.processProcessElements(pojoModel, completedElements, currentElements, breakpoints, processInstanceId);
        if (completedActivityInstances != null) {
            ArrayNode completedActivities = displayNode.putArray("completedActivities");
            for (String completed : completedActivityInstances) {
                completedActivities.add(completed);
            }
        }
        if (currentElements != null) {
            ArrayNode currentActivities = displayNode.putArray("currentActivities");
            for (String current : currentElements) {
                currentActivities.add(current);
            }
        }
        if (completedFlows != null) {
            ArrayNode completedSequenceFlows = displayNode.putArray("completedSequenceFlows");
            for (String current : completedFlows) {
                completedSequenceFlows.add(current);
            }
        }
        return displayNode;
    }

    @RequestMapping(value={"/rest/process-definitions/{processDefinitionId}/model-json"}, method={RequestMethod.GET}, produces={"application/json"})
    public JsonNode getModelJSONForProcessDefinition(@PathVariable String processDefinitionId) {
        BpmnModel pojoModel = this.repositoryService.getBpmnModel(processDefinitionId);
        if (pojoModel == null || pojoModel.getLocationMap().isEmpty()) {
            throw new InternalServerErrorException("Process definition could not be found with id " + processDefinitionId);
        }
        return this.processProcessElements(pojoModel, null, null, Collections.EMPTY_LIST, "");
    }

    @RequestMapping(value={"/rest/process-instances/history/{processInstanceId}/model-json"}, method={RequestMethod.GET}, produces={"application/json"})
    public JsonNode getModelHistoryJSON(@PathVariable String processInstanceId) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        if (!this.permissionService.hasReadPermissionOnProcessInstance(currentUser, processInstanceId)) {
            throw new NotPermittedException();
        }
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new BadRequestException("No process instance found with id " + processInstanceId);
        }
        BpmnModel pojoModel = this.repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
        if (pojoModel == null || pojoModel.getLocationMap().isEmpty()) {
            throw new InternalServerErrorException("Process definition could not be found with id " + processInstance.getProcessDefinitionId());
        }
        List activityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
        HashSet<String> completedActivityInstances = new HashSet<String>();
        HashSet<String> currentActivityinstances = new HashSet<String>();
        if (CollectionUtils.isNotEmpty((Collection)activityInstances)) {
            for (HistoricActivityInstance activityInstance : activityInstances) {
                if (activityInstance.getEndTime() != null) {
                    completedActivityInstances.add(activityInstance.getActivityId());
                    continue;
                }
                currentActivityinstances.add(activityInstance.getActivityId());
            }
        }
        ObjectNode displayNode = this.processProcessElements(pojoModel, completedActivityInstances, currentActivityinstances, Collections.EMPTY_LIST, processInstanceId);
        return displayNode;
    }

    protected ObjectNode processProcessElements(BpmnModel pojoModel, Set<String> completedElements, Set<String> currentElements, Collection<String> breakpoints, String processInstanceId) {
        ObjectNode displayNode = this.objectMapper.createObjectNode();
        GraphicInfo diagramInfo = new GraphicInfo();
        ArrayNode elementArray = this.objectMapper.createArrayNode();
        ArrayNode flowArray = this.objectMapper.createArrayNode();
        ArrayNode collapsedArray = this.objectMapper.createArrayNode();
        if (CollectionUtils.isNotEmpty((Collection)pojoModel.getPools())) {
            ArrayNode poolArray = this.objectMapper.createArrayNode();
            boolean firstElement = true;
            for (Pool pool : pojoModel.getPools()) {
                ObjectNode poolNode = this.objectMapper.createObjectNode();
                poolNode.put("id", pool.getId());
                poolNode.put("name", pool.getName());
                GraphicInfo poolInfo = pojoModel.getGraphicInfo(pool.getId());
                this.fillGraphicInfo(poolNode, poolInfo, true);
                Process process = pojoModel.getProcess(pool.getId());
                if (process != null && CollectionUtils.isNotEmpty((Collection)process.getLanes())) {
                    ArrayNode laneArray = this.objectMapper.createArrayNode();
                    for (Lane lane : process.getLanes()) {
                        ObjectNode laneNode = this.objectMapper.createObjectNode();
                        laneNode.put("id", lane.getId());
                        laneNode.put("name", lane.getName());
                        this.fillGraphicInfo(laneNode, pojoModel.getGraphicInfo(lane.getId()), true);
                        laneArray.add((JsonNode)laneNode);
                    }
                    poolNode.set("lanes", (JsonNode)laneArray);
                }
                poolArray.add((JsonNode)poolNode);
                double rightX = poolInfo.getX() + poolInfo.getWidth();
                double bottomY = poolInfo.getY() + poolInfo.getHeight();
                double middleX = poolInfo.getX() + poolInfo.getWidth() / 2.0;
                if (firstElement || middleX < diagramInfo.getX()) {
                    diagramInfo.setX(middleX);
                }
                if (firstElement || poolInfo.getY() < diagramInfo.getY()) {
                    diagramInfo.setY(poolInfo.getY());
                }
                if (rightX > diagramInfo.getWidth()) {
                    diagramInfo.setWidth(rightX);
                }
                if (bottomY > diagramInfo.getHeight()) {
                    diagramInfo.setHeight(bottomY);
                }
                firstElement = false;
            }
            displayNode.set("pools", (JsonNode)poolArray);
        } else {
            diagramInfo.setX(9999.0);
            diagramInfo.setY(1000.0);
        }
        for (Process process : pojoModel.getProcesses()) {
            this.processElements(process.getFlowElements(), pojoModel, elementArray, flowArray, collapsedArray, diagramInfo, completedElements, currentElements, breakpoints, null, processInstanceId);
            this.processArtifacts(process.getArtifacts(), pojoModel, elementArray, flowArray, diagramInfo);
        }
        displayNode.set("elements", (JsonNode)elementArray);
        displayNode.set("flows", (JsonNode)flowArray);
        displayNode.set("collapsed", (JsonNode)collapsedArray);
        displayNode.put("diagramBeginX", diagramInfo.getX());
        displayNode.put("diagramBeginY", diagramInfo.getY());
        displayNode.put("diagramWidth", diagramInfo.getWidth());
        displayNode.put("diagramHeight", diagramInfo.getHeight());
        return displayNode;
    }

    protected void processElements(Collection<FlowElement> elementList, BpmnModel model, ArrayNode elementArray, ArrayNode flowArray, ArrayNode collapsedArray, GraphicInfo diagramInfo, Set<String> completedElements, Set<String> currentElements, Collection<String> breakpoints, ObjectNode collapsedNode, String processInstanceId) {
        for (FlowElement element : elementList) {
            Collection brokenExecutions;
            ObjectNode elementNode = this.objectMapper.createObjectNode();
            if (completedElements != null) {
                elementNode.put("completed", completedElements.contains(element.getId()));
            }
            if (!breakpoints.isEmpty()) {
                elementNode.put("breakpoint", breakpoints.contains(element.getId()));
            }
            if (!(brokenExecutions = this.debuggerService.getBrokenExecutions(element.getId(), processInstanceId)).isEmpty()) {
                ArrayNode brokenExecutionsNode = elementNode.putArray("brokenExecutions");
                for (String brokenExecution : brokenExecutions) {
                    brokenExecutionsNode.add(brokenExecution);
                }
            }
            if (currentElements != null) {
                elementNode.put("current", currentElements.contains(element.getId()));
            }
            if (element instanceof SequenceFlow) {
                SequenceFlow flow = (SequenceFlow)element;
                elementNode.put("id", flow.getId());
                elementNode.put("type", "sequenceFlow");
                elementNode.put("sourceRef", flow.getSourceRef());
                elementNode.put("targetRef", flow.getTargetRef());
                elementNode.put("name", flow.getName());
                List flowInfo = model.getFlowLocationGraphicInfo(flow.getId());
                if (!CollectionUtils.isNotEmpty((Collection)flowInfo)) continue;
                ArrayNode waypointArray = this.objectMapper.createArrayNode();
                for (GraphicInfo graphicInfo : flowInfo) {
                    ObjectNode pointNode = this.objectMapper.createObjectNode();
                    this.fillGraphicInfo(pointNode, graphicInfo, false);
                    waypointArray.add((JsonNode)pointNode);
                    this.fillDiagramInfo(graphicInfo, diagramInfo);
                }
                elementNode.set("waypoints", (JsonNode)waypointArray);
                String className = element.getClass().getSimpleName();
                if (this.propertyMappers.containsKey(className)) {
                    elementNode.set("properties", (JsonNode)this.propertyMappers.get(className).map((Object)element));
                }
                if (collapsedNode != null) {
                    ((ArrayNode)collapsedNode.get("flows")).add((JsonNode)elementNode);
                    continue;
                }
                flowArray.add((JsonNode)elementNode);
                continue;
            }
            elementNode.put("id", element.getId());
            elementNode.put("name", element.getName());
            GraphicInfo graphicInfo = model.getGraphicInfo(element.getId());
            if (graphicInfo != null) {
                this.fillGraphicInfo(elementNode, graphicInfo, true);
                this.fillDiagramInfo(graphicInfo, diagramInfo);
            }
            String className = element.getClass().getSimpleName();
            elementNode.put("type", className);
            this.fillEventTypes(className, element, elementNode);
            if (element instanceof ServiceTask) {
                ServiceTask serviceTask = (ServiceTask)element;
                if ("mail".equals(serviceTask.getType())) {
                    elementNode.put("taskType", "mail");
                } else if ("camel".equals(serviceTask.getType())) {
                    elementNode.put("taskType", "camel");
                } else if ("mule".equals(serviceTask.getType())) {
                    elementNode.put("taskType", "mule");
                } else if ("http".equals(serviceTask.getType())) {
                    elementNode.put("taskType", "http");
                } else if ("shell".equals(serviceTask.getType())) {
                    elementNode.put("taskType", "shell");
                }
            }
            if (this.propertyMappers.containsKey(className)) {
                elementNode.set("properties", (JsonNode)this.propertyMappers.get(className).map((Object)element));
            }
            if (collapsedNode != null) {
                ((ArrayNode)collapsedNode.get("elements")).add((JsonNode)elementNode);
            } else {
                elementArray.add((JsonNode)elementNode);
            }
            if (!(element instanceof SubProcess)) continue;
            SubProcess subProcess = (SubProcess)element;
            ObjectNode newCollapsedNode = collapsedNode;
            if (graphicInfo != null && graphicInfo.getExpanded() != null && !graphicInfo.getExpanded().booleanValue()) {
                elementNode.put("collapsed", "true");
                newCollapsedNode = this.objectMapper.createObjectNode();
                newCollapsedNode.put("id", subProcess.getId());
                newCollapsedNode.putArray("elements");
                newCollapsedNode.putArray("flows");
                collapsedArray.add((JsonNode)newCollapsedNode);
            }
            this.processElements(subProcess.getFlowElements(), model, elementArray, flowArray, collapsedArray, diagramInfo, completedElements, currentElements, breakpoints, newCollapsedNode, processInstanceId);
            this.processArtifacts(subProcess.getArtifacts(), model, elementArray, flowArray, diagramInfo);
        }
    }

    protected void processArtifacts(Collection<Artifact> artifactList, BpmnModel model, ArrayNode elementArray, ArrayNode flowArray, GraphicInfo diagramInfo) {
        for (Artifact artifact : artifactList) {
            GraphicInfo graphicInfo;
            ObjectNode elementNode;
            if (artifact instanceof Association) {
                elementNode = this.objectMapper.createObjectNode();
                Association flow = (Association)artifact;
                elementNode.put("id", flow.getId());
                elementNode.put("type", "association");
                elementNode.put("sourceRef", flow.getSourceRef());
                elementNode.put("targetRef", flow.getTargetRef());
                this.fillWaypoints(flow.getId(), model, elementNode, diagramInfo);
                flowArray.add((JsonNode)elementNode);
                continue;
            }
            elementNode = this.objectMapper.createObjectNode();
            elementNode.put("id", artifact.getId());
            if (artifact instanceof TextAnnotation) {
                TextAnnotation annotation = (TextAnnotation)artifact;
                elementNode.put("text", annotation.getText());
            }
            if ((graphicInfo = model.getGraphicInfo(artifact.getId())) != null) {
                this.fillGraphicInfo(elementNode, graphicInfo, true);
                this.fillDiagramInfo(graphicInfo, diagramInfo);
            }
            String className = artifact.getClass().getSimpleName();
            elementNode.put("type", className);
            elementArray.add((JsonNode)elementNode);
        }
    }

    protected void fillWaypoints(String id, BpmnModel model, ObjectNode elementNode, GraphicInfo diagramInfo) {
        List flowInfo = model.getFlowLocationGraphicInfo(id);
        ArrayNode waypointArray = this.objectMapper.createArrayNode();
        for (GraphicInfo graphicInfo : flowInfo) {
            ObjectNode pointNode = this.objectMapper.createObjectNode();
            this.fillGraphicInfo(pointNode, graphicInfo, false);
            waypointArray.add((JsonNode)pointNode);
            this.fillDiagramInfo(graphicInfo, diagramInfo);
        }
        elementNode.set("waypoints", (JsonNode)waypointArray);
    }

    protected void fillEventTypes(String className, FlowElement element, ObjectNode elementNode) {
        Event event;
        if (this.eventElementTypes.contains(className) && CollectionUtils.isNotEmpty((Collection)(event = (Event)element).getEventDefinitions())) {
            EventDefinition eventDef = (EventDefinition)event.getEventDefinitions().get(0);
            ObjectNode eventNode = this.objectMapper.createObjectNode();
            if (eventDef instanceof TimerEventDefinition) {
                TimerEventDefinition timerDef = (TimerEventDefinition)eventDef;
                eventNode.put("type", "timer");
                if (StringUtils.isNotEmpty((CharSequence)timerDef.getTimeCycle())) {
                    eventNode.put("timeCycle", timerDef.getTimeCycle());
                }
                if (StringUtils.isNotEmpty((CharSequence)timerDef.getTimeDate())) {
                    eventNode.put("timeDate", timerDef.getTimeDate());
                }
                if (StringUtils.isNotEmpty((CharSequence)timerDef.getTimeDuration())) {
                    eventNode.put("timeDuration", timerDef.getTimeDuration());
                }
            } else if (eventDef instanceof ErrorEventDefinition) {
                ErrorEventDefinition errorDef = (ErrorEventDefinition)eventDef;
                eventNode.put("type", "error");
                if (StringUtils.isNotEmpty((CharSequence)errorDef.getErrorCode())) {
                    eventNode.put("errorCode", errorDef.getErrorCode());
                }
            } else if (eventDef instanceof SignalEventDefinition) {
                SignalEventDefinition signalDef = (SignalEventDefinition)eventDef;
                eventNode.put("type", "signal");
                if (StringUtils.isNotEmpty((CharSequence)signalDef.getSignalRef())) {
                    eventNode.put("signalRef", signalDef.getSignalRef());
                }
            } else if (eventDef instanceof MessageEventDefinition) {
                MessageEventDefinition messageDef = (MessageEventDefinition)eventDef;
                eventNode.put("type", "message");
                if (StringUtils.isNotEmpty((CharSequence)messageDef.getMessageRef())) {
                    eventNode.put("messageRef", messageDef.getMessageRef());
                }
            }
            elementNode.set("eventDefinition", (JsonNode)eventNode);
        }
    }

    protected void fillGraphicInfo(ObjectNode elementNode, GraphicInfo graphicInfo, boolean includeWidthAndHeight) {
        this.commonFillGraphicInfo(elementNode, graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight(), includeWidthAndHeight);
    }

    protected void commonFillGraphicInfo(ObjectNode elementNode, double x, double y, double width, double height, boolean includeWidthAndHeight) {
        elementNode.put("x", x);
        elementNode.put("y", y);
        if (includeWidthAndHeight) {
            elementNode.put("width", width);
            elementNode.put("height", height);
        }
    }

    protected void fillDiagramInfo(GraphicInfo graphicInfo, GraphicInfo diagramInfo) {
        double rightX = graphicInfo.getX() + graphicInfo.getWidth();
        double bottomY = graphicInfo.getY() + graphicInfo.getHeight();
        double middleX = graphicInfo.getX() + graphicInfo.getWidth() / 2.0;
        if (middleX < diagramInfo.getX()) {
            diagramInfo.setX(middleX);
        }
        if (graphicInfo.getY() < diagramInfo.getY()) {
            diagramInfo.setY(graphicInfo.getY());
        }
        if (rightX > diagramInfo.getWidth()) {
            diagramInfo.setWidth(rightX);
        }
        if (bottomY > diagramInfo.getHeight()) {
            diagramInfo.setHeight(bottomY);
        }
    }

    protected List<String> gatherCompletedFlows(Set<String> completedActivityInstances, Set<String> currentActivityinstances, BpmnModel pojoModel) {
        ArrayList<String> completedFlows = new ArrayList<String>();
        ArrayList<String> activities = new ArrayList<String>(completedActivityInstances);
        activities.addAll(currentActivityinstances);
        for (FlowElement activity : pojoModel.getMainProcess().getFlowElements()) {
            int index;
            if (!(activity instanceof FlowNode) || (index = activities.indexOf(activity.getId())) < 0 || index + 1 >= activities.size()) continue;
            List outgoingFlows = ((FlowNode)activity).getOutgoingFlows();
            for (SequenceFlow flow : outgoingFlows) {
                String destinationFlowId = flow.getTargetRef();
                if (!destinationFlowId.equals(activities.get(index + 1))) continue;
                completedFlows.add(flow.getId());
            }
        }
        return completedFlows;
    }
}

