/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletResponse;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.task.model.runtime.ContentItemRepresentation;
import org.flowable.ui.task.rest.runtime.AbstractRelatedContentResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/app"})
public class RelatedContentResource
extends AbstractRelatedContentResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelatedContentResource.class);
    protected ObjectMapper objectMapper = new ObjectMapper();

    @Override
    @RequestMapping(value={"/rest/tasks/{taskId}/content"}, method={RequestMethod.GET})
    public ResultListDataRepresentation getContentItemsForTask(@PathVariable(value="taskId") String taskId) {
        return super.getContentItemsForTask(taskId);
    }

    @Override
    @RequestMapping(value={"/rest/process-instances/{processInstanceId}/content"}, method={RequestMethod.GET})
    public ResultListDataRepresentation getContentItemsForProcessInstance(@PathVariable(value="processInstanceId") String processInstanceId) {
        return super.getContentItemsForProcessInstance(processInstanceId);
    }

    @Override
    @RequestMapping(value={"/rest/case-instances/{caseInstanceId}/content"}, method={RequestMethod.GET})
    public ResultListDataRepresentation getContentItemsForCase(@PathVariable(value="caseInstanceId") String caseInstanceId) {
        return super.getContentItemsForCase(caseInstanceId);
    }

    @Override
    @RequestMapping(value={"/rest/tasks/{taskId}/raw-content"}, method={RequestMethod.POST})
    public ContentItemRepresentation createContentItemOnTask(@PathVariable(value="taskId") String taskId, @RequestParam(value="file") MultipartFile file) {
        return super.createContentItemOnTask(taskId, file);
    }

    @RequestMapping(value={"/rest/tasks/{taskId}/raw-content/text"}, method={RequestMethod.POST})
    public String createContentItemOnTaskText(@PathVariable(value="taskId") String taskId, @RequestParam(value="file") MultipartFile file) {
        ContentItemRepresentation contentItem = super.createContentItemOnTask(taskId, file);
        String contentItemJson = null;
        try {
            contentItemJson = this.objectMapper.writeValueAsString((Object)contentItem);
        }
        catch (Exception e) {
            LOGGER.error("Error while processing ContentItem representation json", (Throwable)e);
            throw new InternalServerErrorException("ContentItem on task could not be saved");
        }
        return contentItemJson;
    }

    @Override
    @RequestMapping(value={"/rest/tasks/{taskId}/content"}, method={RequestMethod.POST})
    public ContentItemRepresentation createContentItemOnTask(@PathVariable(value="taskId") String taskId, @RequestBody ContentItemRepresentation contentItem) {
        return super.createContentItemOnTask(taskId, contentItem);
    }

    @Override
    @RequestMapping(value={"/rest/processes/{processInstanceId}/content"}, method={RequestMethod.POST})
    public ContentItemRepresentation createContentItemOnProcessInstance(@PathVariable(value="processInstanceId") String processInstanceId, @RequestBody ContentItemRepresentation contentItem) {
        return super.createContentItemOnProcessInstance(processInstanceId, contentItem);
    }

    @Override
    @RequestMapping(value={"/rest/process-instances/{processInstanceId}/raw-content"}, method={RequestMethod.POST})
    public ContentItemRepresentation createContentItemOnProcessInstance(@PathVariable(value="processInstanceId") String processInstanceId, @RequestParam(value="file") MultipartFile file) {
        return super.createContentItemOnProcessInstance(processInstanceId, file);
    }

    @RequestMapping(value={"/rest/process-instances/{processInstanceId}/raw-content/text"}, method={RequestMethod.POST})
    public String createContentItemOnProcessInstanceText(@PathVariable(value="processInstanceId") String processInstanceId, @RequestParam(value="file") MultipartFile file) {
        ContentItemRepresentation contentItem = super.createContentItemOnProcessInstance(processInstanceId, file);
        String contentItemJson = null;
        try {
            contentItemJson = this.objectMapper.writeValueAsString((Object)contentItem);
        }
        catch (Exception e) {
            LOGGER.error("Error while processing ContentItem representation json", (Throwable)e);
            throw new InternalServerErrorException("ContentItem on process instance could not be saved");
        }
        return contentItemJson;
    }

    @Override
    @RequestMapping(value={"/rest/case-instances/{caseId}/raw-content"}, method={RequestMethod.POST})
    public ContentItemRepresentation createContentItemOnCase(@PathVariable(value="caseId") String caseId, @RequestParam(value="file") MultipartFile file) {
        return super.createContentItemOnCase(caseId, file);
    }

    @RequestMapping(value={"/rest/case-instances/{caseId}/raw-content/text"}, method={RequestMethod.POST})
    public String createContentItemOnCaseText(@PathVariable(value="caseId") String caseId, @RequestParam(value="file") MultipartFile file) {
        ContentItemRepresentation contentItem = super.createContentItemOnCase(caseId, file);
        String contentItemJson = null;
        try {
            contentItemJson = this.objectMapper.writeValueAsString((Object)contentItem);
        }
        catch (Exception e) {
            LOGGER.error("Error while processing ContentItem representation json", (Throwable)e);
            throw new InternalServerErrorException("ContentItem on process instance could not be saved");
        }
        return contentItemJson;
    }

    @Override
    @RequestMapping(value={"/rest/content/raw"}, method={RequestMethod.POST})
    public ContentItemRepresentation createTemporaryRawContentItem(@RequestParam(value="file") MultipartFile file) {
        return super.createTemporaryRawContentItem(file);
    }

    @RequestMapping(value={"/rest/content/raw/text"}, method={RequestMethod.POST})
    public String createTemporaryRawContentItemText(@RequestParam(value="file") MultipartFile file) {
        ContentItemRepresentation contentItem = super.createTemporaryRawContentItem(file);
        String contentItemJson = null;
        try {
            contentItemJson = this.objectMapper.writeValueAsString((Object)contentItem);
        }
        catch (Exception e) {
            LOGGER.error("Error while processing ContentItem representation json", (Throwable)e);
            throw new InternalServerErrorException("ContentItem could not be saved");
        }
        return contentItemJson;
    }

    @RequestMapping(value={"/rest/content"}, method={RequestMethod.POST})
    public ContentItemRepresentation createTemporaryRelatedContent(@RequestBody ContentItemRepresentation contentItem) {
        return this.addContentItem(contentItem, null, null, false);
    }

    @Override
    @RequestMapping(value={"/rest/content/{contentId}"}, method={RequestMethod.DELETE})
    public void deleteContent(@PathVariable(value="contentId") String contentId, HttpServletResponse response) {
        super.deleteContent(contentId, response);
    }

    @Override
    @RequestMapping(value={"/rest/content/{contentId}"}, method={RequestMethod.GET})
    public ContentItemRepresentation getContent(@PathVariable(value="contentId") String contentId) {
        return super.getContent(contentId);
    }

    @Override
    @RequestMapping(value={"/rest/content/{contentId}/raw"}, method={RequestMethod.GET})
    public void getRawContent(@PathVariable(value="contentId") String contentId, HttpServletResponse response) {
        super.getRawContent(contentId, response);
    }
}

