/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import java.util.Collection;
import java.util.List;
import org.flowable.engine.event.EventLogEntry;
import org.flowable.ui.task.model.debugger.BreakpointRepresentation;
import org.flowable.ui.task.model.debugger.ExecutionRepresentation;
import org.flowable.ui.task.service.debugger.DebuggerRestVariable;
import org.flowable.ui.task.service.debugger.DebuggerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class DebuggerResource {
    @Autowired
    protected DebuggerService debuggerService;
    @Autowired
    protected Environment environment;

    @RequestMapping(value={"/rest/debugger/breakpoints"}, method={RequestMethod.GET}, produces={"application/json"})
    public Collection<BreakpointRepresentation> getBreakpoints() {
        this.assertDebuggerEnabled();
        return this.debuggerService.getBreakpoints();
    }

    @RequestMapping(value={"/rest/debugger/breakpoints"}, method={RequestMethod.POST})
    public void addBreakPoints(@RequestBody BreakpointRepresentation breakpointRepresentation) {
        this.assertDebuggerEnabled();
        this.debuggerService.addBreakpoint(breakpointRepresentation);
    }

    @RequestMapping(value={"/rest/debugger/breakpoints/{executionId}/continue"}, method={RequestMethod.PUT})
    public void continueExecution(@PathVariable String executionId) {
        this.assertDebuggerEnabled();
        this.debuggerService.continueExecution(executionId);
    }

    @RequestMapping(value={"/rest/debugger/breakpoints"}, method={RequestMethod.DELETE})
    public void deleteBreakPoints(@RequestBody BreakpointRepresentation breakpointRepresentation) {
        this.assertDebuggerEnabled();
        this.debuggerService.removeBreakpoint(breakpointRepresentation);
    }

    @RequestMapping(value={"/rest/debugger/eventlog/{processInstanceId}"}, method={RequestMethod.GET})
    public List<EventLogEntry> getEventLog(@PathVariable String processInstanceId) {
        this.assertDebuggerEnabled();
        return this.debuggerService.getProcessInstanceEventLog(processInstanceId);
    }

    @RequestMapping(value={"/rest/debugger/variables/{executionId}"}, method={RequestMethod.GET})
    public List<DebuggerRestVariable> getExecutionVariables(@PathVariable String executionId) {
        this.assertDebuggerEnabled();
        return this.debuggerService.getExecutionVariables(executionId);
    }

    @RequestMapping(value={"/rest/debugger/executions/{processInstanceId}"}, method={RequestMethod.GET})
    public List<ExecutionRepresentation> getExecutions(@PathVariable String processInstanceId) {
        this.assertDebuggerEnabled();
        return this.debuggerService.getExecutions(processInstanceId);
    }

    @RequestMapping(value={"/rest/debugger/evaluate/expression/{executionId}"}, method={RequestMethod.POST}, produces={"application/text"})
    public String evaluateExpression(@PathVariable String executionId, @RequestBody String expression) {
        this.assertDebuggerEnabled();
        return this.debuggerService.evaluateExpression(executionId, expression).toString();
    }

    @RequestMapping(value={"/rest/debugger/evaluate/{scriptLanguage}/{executionId}"}, method={RequestMethod.POST})
    public void evaluateScript(@PathVariable String executionId, @PathVariable String scriptLanguage, @RequestBody String script) {
        this.assertDebuggerEnabled();
        this.debuggerService.evaluateScript(executionId, scriptLanguage, script);
    }

    @RequestMapping(value={"/rest/debugger"}, method={RequestMethod.GET})
    public boolean isDebuggerAllowed() {
        return (Boolean)this.environment.getProperty("flowable.experimental.debugger.enabled", Boolean.class, (Object)false);
    }

    protected void assertDebuggerEnabled() {
        if (!((Boolean)this.environment.getProperty("flowable.experimental.debugger.enabled", Boolean.class, (Object)false)).booleanValue()) {
            throw new RuntimeException("property flowable.experimental.debugger.enabled is not enabled");
        }
    }
}

