/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import javax.servlet.http.HttpServletResponse;
import org.flowable.form.api.FormInfo;
import org.flowable.form.model.SimpleFormModel;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.task.model.runtime.CaseInstanceRepresentation;
import org.flowable.ui.task.model.runtime.FormModelRepresentation;
import org.flowable.ui.task.service.runtime.FlowableCaseInstanceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class CaseInstanceResource {
    @Autowired
    protected FlowableCaseInstanceService caseInstanceService;

    @RequestMapping(value={"/rest/case-instances/{caseInstanceId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public CaseInstanceRepresentation getCaseInstance(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstance(caseInstanceId);
    }

    @RequestMapping(value={"/rest/case-instances/{caseInstanceId}/start-form"}, method={RequestMethod.GET}, produces={"application/json"})
    public FormModelRepresentation getCaseInstanceStartForm(@PathVariable String caseInstanceId, HttpServletResponse response) {
        FormInfo formInfo = this.caseInstanceService.getCaseInstanceStartForm(caseInstanceId);
        SimpleFormModel formModel = (SimpleFormModel)formInfo.getFormModel();
        return new FormModelRepresentation(formInfo, formModel);
    }

    @RequestMapping(value={"/rest/case-instances/{caseInstanceId}/active-stages"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultListDataRepresentation getCaseInstanceActiveStages(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstanceActiveStages(caseInstanceId);
    }

    @RequestMapping(value={"/rest/case-instances/{caseInstanceId}/ended-stages"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultListDataRepresentation getCaseInstanceEndedStages(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstanceEndedStages(caseInstanceId);
    }

    @RequestMapping(value={"/rest/case-instances/{caseInstanceId}/available-milestones"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultListDataRepresentation getCaseInstanceAvailableMilestones(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstanceAvailableMilestones(caseInstanceId);
    }

    @RequestMapping(value={"/rest/case-instances/{caseInstanceId}/ended-milestones"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultListDataRepresentation getCaseInstanceEndedMilestones(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstanceEndedMilestones(caseInstanceId);
    }

    @RequestMapping(value={"/rest/case-instances/{caseInstanceId}/available-user-event-listeners"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultListDataRepresentation getCaseInstanceAvailableUserEventListeners(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstanceAvailableUserEventListeners(caseInstanceId);
    }

    @RequestMapping(value={"/rest/case-instances/{caseInstanceId}/completed-user-event-listeners"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResultListDataRepresentation getCaseInstanceCompletedUserEventListeners(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstanceCompletedUserEventListeners(caseInstanceId);
    }

    @RequestMapping(value={"/rest/case-instances/{caseInstanceId}/trigger-user-event-listener/{userEventListenerId}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void triggerUserEventListener(@PathVariable String caseInstanceId, @PathVariable String userEventListenerId) {
        this.caseInstanceService.triggerUserEventListener(caseInstanceId, userEventListenerId);
    }

    @RequestMapping(value={"/rest/case-instances/{caseInstanceId}/enabled-planitem-instances"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public ResultListDataRepresentation getCaseInstanceEnabledPlanItemInstances(@PathVariable String caseInstanceId) {
        return this.caseInstanceService.getCaseInstanceEnabledPlanItemInstances(caseInstanceId);
    }

    @RequestMapping(value={"/rest/case-instances/{caseInstanceId}/enabled-planitem-instances/{planItemInstanceId}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void startEnabledPlanItemInstance(@PathVariable String caseInstanceId, @PathVariable String planItemInstanceId) {
        this.caseInstanceService.startEnabledPlanItemInstance(caseInstanceId, planItemInstanceId);
    }

    @RequestMapping(value={"/rest/case-instances/{caseInstanceId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteCaseInstance(@PathVariable String caseInstanceId) {
        this.caseInstanceService.deleteCaseInstance(caseInstanceId);
    }
}

