/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.history.HistoricPlanItemInstance;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.model.Association;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Criterion;
import org.flowable.cmmn.model.GraphicInfo;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.ServiceTask;
import org.flowable.cmmn.model.Stage;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.idm.api.User;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.common.service.exception.NotPermittedException;
import org.flowable.ui.task.service.editor.mapper.InfoMapper;
import org.flowable.ui.task.service.runtime.PermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class CaseInstanceDisplayJsonClientResource {
    @Autowired
    protected CmmnRepositoryService cmmnRepositoryService;
    @Autowired
    protected CmmnRuntimeService cmmnRuntimeService;
    @Autowired
    protected CmmnHistoryService cmmnHistoryService;
    @Autowired
    protected PermissionService permissionService;
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected List<String> eventElementTypes = new ArrayList<String>();
    protected Map<String, InfoMapper> propertyMappers = new HashMap<String, InfoMapper>();

    @RequestMapping(value={"/rest/case-instances/{caseInstanceId}/model-json"}, method={RequestMethod.GET}, produces={"application/json"})
    public JsonNode getModelJSON(@PathVariable String caseInstanceId) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        if (!this.permissionService.hasReadPermissionOnCase(currentUser, caseInstanceId)) {
            throw new NotPermittedException();
        }
        CaseInstance caseInstance = (CaseInstance)this.cmmnRuntimeService.createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (caseInstance == null) {
            throw new BadRequestException("No case instance found with id " + caseInstanceId);
        }
        CmmnModel pojoModel = this.cmmnRepositoryService.getCmmnModel(caseInstance.getCaseDefinitionId());
        if (pojoModel == null || pojoModel.getLocationMap().isEmpty()) {
            throw new InternalServerErrorException("Case definition could not be found with id " + caseInstance.getCaseDefinitionId());
        }
        List planItemInstances = this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstanceId).includeEnded().list();
        HashSet<String> completedPlanItemInstances = new HashSet<String>();
        HashSet<String> activePlanItemInstances = new HashSet<String>();
        HashSet<String> availablePlanItemInstances = new HashSet<String>();
        if (CollectionUtils.isNotEmpty((Collection)planItemInstances)) {
            for (PlanItemInstance planItemInstance : planItemInstances) {
                if (planItemInstance.getCompletedTime() != null || planItemInstance.getTerminatedTime() != null || planItemInstance.getOccurredTime() != null) {
                    completedPlanItemInstances.add(planItemInstance.getPlanItemDefinitionId());
                    continue;
                }
                if ("active".equals(planItemInstance.getState())) {
                    activePlanItemInstances.add(planItemInstance.getPlanItemDefinitionId());
                    continue;
                }
                if (!"available".equals(planItemInstance.getState())) continue;
                availablePlanItemInstances.add(planItemInstance.getPlanItemDefinitionId());
            }
        }
        ObjectNode displayNode = this.processCaseElements(pojoModel, completedPlanItemInstances, activePlanItemInstances, availablePlanItemInstances);
        ArrayNode completedActivities = displayNode.putArray("completedActivities");
        for (String string : completedPlanItemInstances) {
            completedActivities.add(string);
        }
        ArrayNode currentActivities = displayNode.putArray("currentActivities");
        for (String current : activePlanItemInstances) {
            currentActivities.add(current);
        }
        ArrayNode arrayNode = displayNode.putArray("availableActivities");
        for (String available : availablePlanItemInstances) {
            arrayNode.add(available);
        }
        return displayNode;
    }

    @RequestMapping(value={"/rest/case-definitions/{caseDefinitionId}/model-json"}, method={RequestMethod.GET}, produces={"application/json"})
    public JsonNode getModelJSONForCaseDefinition(@PathVariable String caseDefinitionId) {
        CmmnModel pojoModel = this.cmmnRepositoryService.getCmmnModel(caseDefinitionId);
        if (pojoModel == null || pojoModel.getLocationMap().isEmpty()) {
            throw new InternalServerErrorException("Case definition could not be found with id " + caseDefinitionId);
        }
        return this.processCaseElements(pojoModel, null, null, null);
    }

    @RequestMapping(value={"/rest/case-instances/history/{caseInstanceId}/model-json"}, method={RequestMethod.GET}, produces={"application/json"})
    public JsonNode getModelHistoryJSON(@PathVariable String caseInstanceId) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        if (!this.permissionService.hasReadPermissionOnCase(currentUser, caseInstanceId)) {
            throw new NotPermittedException();
        }
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (caseInstance == null) {
            throw new BadRequestException("No case instance found with id " + caseInstanceId);
        }
        CmmnModel pojoModel = this.cmmnRepositoryService.getCmmnModel(caseInstance.getCaseDefinitionId());
        if (pojoModel == null || pojoModel.getLocationMap().isEmpty()) {
            throw new InternalServerErrorException("Case definition could not be found with id " + caseInstance.getCaseDefinitionId());
        }
        List planItemInstances = this.cmmnHistoryService.createHistoricPlanItemInstanceQuery().planItemInstanceCaseInstanceId(caseInstanceId).list();
        HashSet<String> completedPlanItemInstances = new HashSet<String>();
        HashSet<String> activePlanItemInstances = new HashSet<String>();
        HashSet<String> availablePlanItemInstances = new HashSet<String>();
        if (CollectionUtils.isNotEmpty((Collection)planItemInstances)) {
            for (HistoricPlanItemInstance planItemInstance : planItemInstances) {
                if (planItemInstance.getCompletedTime() != null || planItemInstance.getTerminatedTime() != null || planItemInstance.getOccurredTime() != null) {
                    completedPlanItemInstances.add(planItemInstance.getPlanItemDefinitionId());
                    continue;
                }
                if ("active".equals(planItemInstance.getState())) {
                    activePlanItemInstances.add(planItemInstance.getPlanItemDefinitionId());
                    continue;
                }
                if (!"available".equals(planItemInstance.getState())) continue;
                availablePlanItemInstances.add(planItemInstance.getPlanItemDefinitionId());
            }
        }
        ObjectNode displayNode = this.processCaseElements(pojoModel, completedPlanItemInstances, activePlanItemInstances, availablePlanItemInstances);
        return displayNode;
    }

    protected ObjectNode processCaseElements(CmmnModel pojoModel, Set<String> completedElements, Set<String> activeElements, Set<String> availableElements) {
        ObjectNode elementNode;
        ObjectNode displayNode = this.objectMapper.createObjectNode();
        GraphicInfo diagramInfo = new GraphicInfo();
        ArrayNode elementArray = this.objectMapper.createArrayNode();
        ArrayNode associationArray = this.objectMapper.createArrayNode();
        diagramInfo.setX(9999.0);
        diagramInfo.setY(1000.0);
        for (Case caseObject : pojoModel.getCases()) {
            elementNode = this.objectMapper.createObjectNode();
            elementNode.put("id", caseObject.getPlanModel().getId());
            elementNode.put("name", caseObject.getPlanModel().getName());
            GraphicInfo graphicInfo = pojoModel.getGraphicInfo(caseObject.getPlanModel().getId());
            if (graphicInfo != null) {
                this.fillGraphicInfo(elementNode, graphicInfo, true);
                this.fillDiagramInfo(graphicInfo, diagramInfo);
            }
            elementNode.put("type", "PlanModel");
            elementArray.add((JsonNode)elementNode);
            this.processCriteria(caseObject.getPlanModel().getExitCriteria(), "ExitCriterion", pojoModel, elementArray);
            this.processElements(caseObject.getPlanModel().getPlanItems(), pojoModel, elementArray, associationArray, completedElements, activeElements, availableElements, diagramInfo);
        }
        for (Association association : pojoModel.getAssociations()) {
            elementNode = this.objectMapper.createObjectNode();
            elementNode.put("id", association.getId());
            elementNode.put("type", "Association");
            elementNode.put("sourceRef", association.getSourceRef());
            elementNode.put("targetRef", association.getTargetRef());
            List flowInfo = pojoModel.getFlowLocationGraphicInfo(association.getId());
            if (!CollectionUtils.isNotEmpty((Collection)flowInfo)) continue;
            ArrayNode waypointArray = this.objectMapper.createArrayNode();
            for (GraphicInfo graphicInfo : flowInfo) {
                ObjectNode pointNode = this.objectMapper.createObjectNode();
                this.fillGraphicInfo(pointNode, graphicInfo, false);
                waypointArray.add((JsonNode)pointNode);
                this.fillDiagramInfo(graphicInfo, diagramInfo);
            }
            elementNode.set("waypoints", (JsonNode)waypointArray);
            associationArray.add((JsonNode)elementNode);
        }
        displayNode.set("elements", (JsonNode)elementArray);
        displayNode.set("flows", (JsonNode)associationArray);
        displayNode.put("diagramBeginX", diagramInfo.getX());
        displayNode.put("diagramBeginY", diagramInfo.getY());
        displayNode.put("diagramWidth", diagramInfo.getWidth());
        displayNode.put("diagramHeight", diagramInfo.getHeight());
        return displayNode;
    }

    protected void processElements(List<PlanItem> planItemList, CmmnModel model, ArrayNode elementArray, ArrayNode flowArray, Set<String> completedElements, Set<String> activeElements, Set<String> availableElements, GraphicInfo diagramInfo) {
        for (PlanItem planItem : planItemList) {
            GraphicInfo graphicInfo;
            ObjectNode elementNode = this.objectMapper.createObjectNode();
            elementNode.put("id", planItem.getId());
            elementNode.put("name", planItem.getName());
            PlanItemDefinition planItemDefinition = planItem.getPlanItemDefinition();
            String className = planItemDefinition.getClass().getSimpleName();
            elementNode.put("type", className);
            if (completedElements != null) {
                elementNode.put("completed", completedElements.contains(planItemDefinition.getId()));
            }
            if (activeElements != null) {
                elementNode.put("current", activeElements.contains(planItemDefinition.getId()));
            }
            if (availableElements != null) {
                elementNode.put("available", availableElements.contains(planItemDefinition.getId()));
            }
            if ((graphicInfo = model.getGraphicInfo(planItem.getId())) != null) {
                this.fillGraphicInfo(elementNode, graphicInfo, true);
                this.fillDiagramInfo(graphicInfo, diagramInfo);
            }
            if (planItemDefinition instanceof ServiceTask) {
                ServiceTask serviceTask = (ServiceTask)planItemDefinition;
                if ("mail".equals(serviceTask.getType())) {
                    elementNode.put("taskType", "mail");
                } else if ("http".equals(serviceTask.getType())) {
                    elementNode.put("taskType", "http");
                }
            }
            elementArray.add((JsonNode)elementNode);
            this.processCriteria(planItem.getEntryCriteria(), "EntryCriterion", model, elementArray);
            this.processCriteria(planItem.getExitCriteria(), "ExitCriterion", model, elementArray);
            if (!(planItemDefinition instanceof Stage)) continue;
            Stage stage = (Stage)planItemDefinition;
            this.processElements(stage.getPlanItems(), model, elementArray, flowArray, completedElements, activeElements, availableElements, diagramInfo);
        }
    }

    protected void processCriteria(List<Criterion> criteria, String type, CmmnModel model, ArrayNode elementArray) {
        for (Criterion criterion : criteria) {
            ObjectNode criterionNode = this.objectMapper.createObjectNode();
            criterionNode.put("id", criterion.getId());
            criterionNode.put("name", criterion.getName());
            criterionNode.put("type", type);
            GraphicInfo criterionGraphicInfo = model.getGraphicInfo(criterion.getId());
            if (criterionGraphicInfo != null) {
                this.fillGraphicInfo(criterionNode, criterionGraphicInfo, true);
            }
            elementArray.add((JsonNode)criterionNode);
        }
    }

    protected void fillWaypoints(String id, CmmnModel model, ObjectNode elementNode, GraphicInfo diagramInfo) {
        List flowInfo = model.getFlowLocationGraphicInfo(id);
        ArrayNode waypointArray = this.objectMapper.createArrayNode();
        for (GraphicInfo graphicInfo : flowInfo) {
            ObjectNode pointNode = this.objectMapper.createObjectNode();
            this.fillGraphicInfo(pointNode, graphicInfo, false);
            waypointArray.add((JsonNode)pointNode);
            this.fillDiagramInfo(graphicInfo, diagramInfo);
        }
        elementNode.set("waypoints", (JsonNode)waypointArray);
    }

    protected void fillGraphicInfo(ObjectNode elementNode, GraphicInfo graphicInfo, boolean includeWidthAndHeight) {
        this.commonFillGraphicInfo(elementNode, graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight(), includeWidthAndHeight);
    }

    protected void commonFillGraphicInfo(ObjectNode elementNode, double x, double y, double width, double height, boolean includeWidthAndHeight) {
        elementNode.put("x", x);
        elementNode.put("y", y);
        if (includeWidthAndHeight) {
            elementNode.put("width", width);
            elementNode.put("height", height);
        }
    }

    protected void fillDiagramInfo(GraphicInfo graphicInfo, GraphicInfo diagramInfo) {
        double rightX = graphicInfo.getX() + graphicInfo.getWidth();
        double bottomY = graphicInfo.getY() + graphicInfo.getHeight();
        double middleX = graphicInfo.getX() + graphicInfo.getWidth() / 2.0;
        if (middleX < diagramInfo.getX()) {
            diagramInfo.setX(middleX);
        }
        if (graphicInfo.getY() < diagramInfo.getY()) {
            diagramInfo.setY(graphicInfo.getY());
        }
        if (rightX > diagramInfo.getWidth()) {
            diagramInfo.setWidth(rightX);
        }
        if (bottomY > diagramInfo.getHeight()) {
            diagramInfo.setHeight(bottomY);
        }
    }
}

