/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.content.api.ContentItem;
import org.flowable.content.api.ContentService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.TaskService;
import org.flowable.idm.api.User;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.common.service.exception.NotPermittedException;
import org.flowable.ui.task.model.component.SimpleContentTypeMapper;
import org.flowable.ui.task.model.runtime.ContentItemRepresentation;
import org.flowable.ui.task.service.api.UserCache;
import org.flowable.ui.task.service.runtime.PermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractRelatedContentResource {
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected ContentService contentService;
    @Autowired
    protected TaskService taskService;
    @Autowired
    protected SimpleContentTypeMapper simpleTypeMapper;
    @Autowired
    protected HistoryService historyService;
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected UserCache userCache;

    public ResultListDataRepresentation getContentItemsForTask(String taskId) {
        this.permissionService.validateReadPermissionOnTask(SecurityUtils.getCurrentUserObject(), taskId);
        return this.createResultRepresentation(this.contentService.createContentItemQuery().taskId(taskId).list());
    }

    public ResultListDataRepresentation getContentItemsForCase(String caseInstanceId) {
        this.permissionService.hasReadPermissionOnCase(SecurityUtils.getCurrentUserObject(), caseInstanceId);
        return this.createResultRepresentation(this.contentService.createContentItemQuery().scopeType("cmmn").scopeId(caseInstanceId).list());
    }

    public ResultListDataRepresentation getContentItemsForProcessInstance(String processInstanceId) {
        if (!this.permissionService.hasReadPermissionOnProcessInstance(SecurityUtils.getCurrentUserObject(), processInstanceId)) {
            throw new NotPermittedException("You are not allowed to read the process with id: " + processInstanceId);
        }
        return this.createResultRepresentation(this.contentService.createContentItemQuery().processInstanceId(processInstanceId).list());
    }

    public ContentItemRepresentation createContentItemOnTask(String taskId, MultipartFile file) {
        User user = SecurityUtils.getCurrentUserObject();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task not found or already completed: " + taskId);
        }
        if (!this.permissionService.canAddRelatedContentToTask(user, taskId)) {
            throw new NotPermittedException("You are not allowed to read the task with id: " + taskId);
        }
        return this.uploadFile(user, file, taskId, task.getProcessInstanceId(), null);
    }

    public ContentItemRepresentation createContentItemOnTask(String taskId, ContentItemRepresentation contentItem) {
        User user = SecurityUtils.getCurrentUserObject();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new NotFoundException("Task not found or already completed: " + taskId);
        }
        if (!this.permissionService.canAddRelatedContentToTask(user, taskId)) {
            throw new NotPermittedException("You are not allowed to read the task with id: " + taskId);
        }
        return this.addContentItem(contentItem, taskId, task.getProcessInstanceId(), true);
    }

    public ContentItemRepresentation createContentItemOnProcessInstance(String processInstanceId, ContentItemRepresentation contentItem) {
        User user = SecurityUtils.getCurrentUserObject();
        if (!this.permissionService.canAddRelatedContentToProcessInstance(user, processInstanceId)) {
            throw new NotPermittedException("You are not allowed to read the process with id: " + processInstanceId);
        }
        return this.addContentItem(contentItem, null, processInstanceId, true);
    }

    public ContentItemRepresentation createContentItemOnProcessInstance(String processInstanceId, MultipartFile file) {
        User user = SecurityUtils.getCurrentUserObject();
        if (!this.permissionService.canAddRelatedContentToProcessInstance(user, processInstanceId)) {
            throw new NotPermittedException("You are not allowed to read the process with id: " + processInstanceId);
        }
        return this.uploadFile(user, file, null, processInstanceId, null);
    }

    public ContentItemRepresentation createContentItemOnCase(String caseId, MultipartFile file) {
        User user = SecurityUtils.getCurrentUserObject();
        if (!this.permissionService.canAddRelatedContentToCase(user, caseId)) {
            throw new NotPermittedException("You are not allowed to read the case with id: " + caseId);
        }
        return this.uploadFile(user, file, null, null, caseId);
    }

    public ContentItemRepresentation createTemporaryRawContentItem(MultipartFile file) {
        User user = SecurityUtils.getCurrentUserObject();
        return this.uploadFile(user, file, null, null, null);
    }

    public ContentItemRepresentation createTemporaryContentItem(ContentItemRepresentation contentItem) {
        return this.addContentItem(contentItem, null, null, false);
    }

    public void deleteContent(String contentId, HttpServletResponse response) {
        ContentItem contentItem = (ContentItem)this.contentService.createContentItemQuery().id(contentId).singleResult();
        if (contentItem == null) {
            throw new NotFoundException("No content found with id: " + contentId);
        }
        if (!this.permissionService.hasWritePermissionOnRelatedContent(SecurityUtils.getCurrentUserObject(), contentItem)) {
            throw new NotPermittedException("You are not allowed to delete the content with id: " + contentId);
        }
        if (contentItem.getField() != null) {
            throw new NotPermittedException("You are not allowed to delete the content with id: " + contentId);
        }
        this.contentService.deleteContentItem(contentItem.getId());
    }

    public ContentItemRepresentation getContent(String contentId) {
        ContentItem contentItem = (ContentItem)this.contentService.createContentItemQuery().id(contentId).singleResult();
        if (contentItem == null) {
            throw new NotFoundException("No content found with id: " + contentId);
        }
        if (!this.permissionService.canDownloadContent(SecurityUtils.getCurrentUserObject(), contentItem)) {
            throw new NotPermittedException("You are not allowed to view the content with id: " + contentId);
        }
        return this.createContentItemResponse(contentItem);
    }

    public void getRawContent(String contentId, HttpServletResponse response) {
        ContentItem contentItem = (ContentItem)this.contentService.createContentItemQuery().id(contentId).singleResult();
        if (contentItem == null) {
            throw new NotFoundException("No content found with id: " + contentId);
        }
        if (!contentItem.isContentAvailable()) {
            throw new NotFoundException("Raw content not yet available for id: " + contentId);
        }
        if (!this.permissionService.canDownloadContent(SecurityUtils.getCurrentUserObject(), contentItem)) {
            throw new NotPermittedException("You are not allowed to read the content with id: " + contentId);
        }
        if (contentItem.getMimeType() != null) {
            response.setContentType(contentItem.getMimeType());
        }
        try (InputStream inputstream = this.contentService.getContentItemData(contentId);){
            IOUtils.copy((InputStream)inputstream, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error while writing raw content data for content: " + contentId, (Throwable)e);
        }
    }

    protected ContentItemRepresentation uploadFile(User user, MultipartFile file, String taskId, String processInstanceId, String caseId) {
        if (file != null && file.getName() != null) {
            try {
                String contentType = file.getContentType();
                if (StringUtils.equals((CharSequence)file.getContentType(), (CharSequence)"application/octet-stream")) {
                    contentType = this.getContentTypeForFileExtension(file);
                }
                ContentItem contentItem = this.contentService.newContentItem();
                contentItem.setName(this.getFileName(file));
                contentItem.setProcessInstanceId(processInstanceId);
                contentItem.setTaskId(taskId);
                if (StringUtils.isNotEmpty((CharSequence)caseId)) {
                    contentItem.setScopeType("cmmn");
                    contentItem.setScopeId(caseId);
                }
                contentItem.setMimeType(contentType);
                contentItem.setCreatedBy(user.getId());
                contentItem.setLastModifiedBy(user.getId());
                this.contentService.saveContentItem(contentItem, file.getInputStream());
                return this.createContentItemResponse(contentItem);
            }
            catch (IOException e) {
                throw new BadRequestException("Error while reading file data", (Throwable)e);
            }
        }
        throw new BadRequestException("File to upload is missing");
    }

    protected ContentItemRepresentation addContentItem(ContentItemRepresentation contentItemBody, String taskId, String processInstanceId, boolean isRelatedContent) {
        if (contentItemBody.getContentStoreId() == null || contentItemBody.getContentStoreName() == null || contentItemBody.getName() == null) {
            throw new BadRequestException("Name, source and sourceId are required parameters");
        }
        User user = SecurityUtils.getCurrentUserObject();
        ContentItem contentItem = this.contentService.newContentItem();
        contentItem.setName(contentItemBody.getName());
        contentItem.setProcessInstanceId(processInstanceId);
        contentItem.setTaskId(taskId);
        contentItem.setContentStoreId(contentItemBody.getContentStoreId());
        contentItem.setContentStoreName(contentItemBody.getContentStoreName());
        contentItem.setMimeType(contentItemBody.getMimeType());
        contentItem.setCreatedBy(user.getId());
        contentItem.setLastModifiedBy(user.getId());
        this.contentService.saveContentItem(contentItem);
        return this.createContentItemResponse(contentItem);
    }

    protected String getFileName(MultipartFile file) {
        return file.getOriginalFilename() != null ? file.getOriginalFilename() : "Nameless file";
    }

    protected ResultListDataRepresentation createResultRepresentation(List<ContentItem> results) {
        ArrayList<ContentItemRepresentation> resultList = new ArrayList<ContentItemRepresentation>(results.size());
        for (ContentItem content : results) {
            resultList.add(this.createContentItemResponse(content));
        }
        ResultListDataRepresentation result = new ResultListDataRepresentation(resultList);
        result.setTotal(Long.valueOf(results.size()));
        return result;
    }

    protected ContentItemRepresentation createContentItemResponse(ContentItem contentItem) {
        ContentItemRepresentation contentItemResponse = new ContentItemRepresentation(contentItem, this.simpleTypeMapper);
        return contentItemResponse;
    }

    protected String getContentTypeForFileExtension(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        String contentType = null;
        if (fileName.endsWith(".jpeg") || fileName.endsWith(".jpg")) {
            contentType = "image/jpeg";
        } else if (fileName.endsWith("gif")) {
            contentType = "image/gif";
        } else if (fileName.endsWith("png")) {
            contentType = "image/png";
        } else if (fileName.endsWith("bmp")) {
            contentType = "image/bmp";
        } else if (fileName.endsWith("tif") || fileName.endsWith(".tiff")) {
            contentType = "image/tiff";
        } else if (fileName.endsWith("doc")) {
            contentType = "application/msword";
        } else if (fileName.endsWith("docx")) {
            contentType = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
        } else if (fileName.endsWith("docm")) {
            contentType = "application/vnd.ms-word.document.macroenabled.12";
        } else if (fileName.endsWith("dotm")) {
            contentType = "application/vnd.ms-word.template.macroenabled.12";
        } else if (fileName.endsWith("odt")) {
            contentType = "application/vnd.oasis.opendocument.text";
        } else if (fileName.endsWith("ott")) {
            contentType = "application/vnd.oasis.opendocument.text-template";
        } else if (fileName.endsWith("rtf")) {
            contentType = "application/rtf";
        } else if (fileName.endsWith("txt")) {
            contentType = "application/text";
        } else if (fileName.endsWith("xls")) {
            contentType = "application/vnd.ms-excel";
        } else if (fileName.endsWith("xlsx")) {
            contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        } else if (fileName.endsWith("xlsb")) {
            contentType = "application/vnd.ms-excel.sheet.binary.macroenabled.12";
        } else if (fileName.endsWith("xltx")) {
            contentType = "application/vnd.openxmlformats-officedocument.spreadsheetml.template";
        } else if (fileName.endsWith("ods")) {
            contentType = "application/vnd.oasis.opendocument.spreadsheet";
        } else if (fileName.endsWith("ppt")) {
            contentType = "application/vnd.ms-powerpoint";
        } else if (fileName.endsWith("pptx")) {
            contentType = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
        } else if (fileName.endsWith("ppsm")) {
            contentType = "application/vnd.ms-powerpoint.slideshow.macroenabled.12";
        } else if (fileName.endsWith("ppsx")) {
            contentType = "application/vnd.openxmlformats-officedocument.presentationml.slideshow";
        } else if (fileName.endsWith("odp")) {
            contentType = "application/vnd.oasis.opendocument.presentation";
        } else {
            return file.getContentType();
        }
        return contentType;
    }
}

