/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.service.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppDefinition;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.repository.ProcessDefinitionQuery;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.task.model.runtime.ProcessDefinitionRepresentation;
import org.flowable.ui.task.service.runtime.PermissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableProcessDefinitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableProcessDefinitionService.class);
    @Autowired
    protected RepositoryService repositoryService;
    @Autowired
    protected ProcessEngineConfiguration processEngineConfiguration;
    @Autowired
    protected AppRepositoryService appRepositoryService;
    @Autowired
    protected FormRepositoryService formRepositoryService;
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected ObjectMapper objectMapper;

    public FormInfo getProcessDefinitionStartForm(String processDefinitionId) {
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(processDefinitionId);
        try {
            return this.getStartForm(processDefinition);
        }
        catch (FlowableObjectNotFoundException aonfe) {
            throw new NotFoundException("No process definition found with the given id: " + processDefinitionId);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultListDataRepresentation getProcessDefinitions(Boolean latest, String appDefinitionKey) {
        ProcessDefinitionQuery definitionQuery = this.repositoryService.createProcessDefinitionQuery();
        if (appDefinitionKey != null) {
            AppDefinition appDefinition = (AppDefinition)this.appRepositoryService.createAppDefinitionQuery().appDefinitionKey(appDefinitionKey).latestVersion().singleResult();
            Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().parentDeploymentId(appDefinition.getDeploymentId()).singleResult();
            if (deployment == null) return new ResultListDataRepresentation(new ArrayList());
            definitionQuery.deploymentId(deployment.getId());
        } else if (latest != null && latest.booleanValue()) {
            definitionQuery.latestVersion();
        }
        List definitions = definitionQuery.list();
        ArrayList<ProcessDefinition> startableDefinitions = new ArrayList<ProcessDefinition>();
        Iterator iterator = definitions.iterator();
        while (iterator.hasNext()) {
            ProcessDefinition definition = (ProcessDefinition)iterator.next();
            if (SecurityUtils.getCurrentUserObject() != null && !this.permissionService.canStartProcess(SecurityUtils.getCurrentUserObject(), definition)) continue;
            startableDefinitions.add(definition);
        }
        return new ResultListDataRepresentation(this.convertDefinitionList(startableDefinitions));
    }

    protected FormInfo getStartForm(ProcessDefinition processDefinition) {
        StartEvent startEvent;
        FormInfo formInfo = null;
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        Process process = bpmnModel.getProcessById(processDefinition.getKey());
        FlowElement startElement = process.getInitialFlowElement();
        if (startElement instanceof StartEvent && StringUtils.isNotEmpty((CharSequence)(startEvent = (StartEvent)startElement).getFormKey())) {
            Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(processDefinition.getDeploymentId()).singleResult();
            formInfo = this.formRepositoryService.getFormModelByKeyAndParentDeploymentId(startEvent.getFormKey(), deployment.getParentDeploymentId(), processDefinition.getTenantId(), this.processEngineConfiguration.isFallbackToDefaultTenant());
        }
        if (formInfo == null) {
            throw new NotFoundException("Process definition does not have a form defined: " + processDefinition.getId());
        }
        return formInfo;
    }

    protected List<ProcessDefinitionRepresentation> convertDefinitionList(List<ProcessDefinition> definitions) {
        ArrayList<ProcessDefinitionRepresentation> result = new ArrayList<ProcessDefinitionRepresentation>();
        if (CollectionUtils.isNotEmpty(definitions)) {
            for (ProcessDefinition processDefinition : definitions) {
                ProcessDefinitionRepresentation rep = new ProcessDefinitionRepresentation(processDefinition);
                result.add(rep);
            }
        }
        return result;
    }
}

