/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.service.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.PlanItemDefinitionType;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.UserEventListenerInstance;
import org.flowable.content.api.ContentService;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.idm.api.User;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.task.model.runtime.CaseInstanceRepresentation;
import org.flowable.ui.task.model.runtime.CreateCaseInstanceRepresentation;
import org.flowable.ui.task.model.runtime.MilestoneRepresentation;
import org.flowable.ui.task.model.runtime.PlanItemInstanceRepresentation;
import org.flowable.ui.task.model.runtime.StageRepresentation;
import org.flowable.ui.task.model.runtime.UserEventListenerRepresentation;
import org.flowable.ui.task.service.api.UserCache;
import org.flowable.ui.task.service.runtime.FlowableCommentService;
import org.flowable.ui.task.service.runtime.PermissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableCaseInstanceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableCaseInstanceService.class);
    @Autowired
    protected CmmnRepositoryService cmmnRepositoryService;
    @Autowired
    protected CmmnRuntimeService cmmnRuntimeService;
    @Autowired
    protected CmmnHistoryService cmmnHistoryService;
    @Autowired
    protected FormService formService;
    @Autowired
    protected FormRepositoryService formRepositoryService;
    @Autowired
    protected PermissionService permissionService;
    @Autowired
    protected ContentService contentService;
    @Autowired
    protected FlowableCommentService commentService;
    @Autowired
    protected UserCache userCache;

    public CaseInstanceRepresentation getCaseInstance(String caseInstanceId) {
        UserCache.CachedUser user;
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        CaseDefinition caseDefinition = this.cmmnRepositoryService.getCaseDefinition(caseInstance.getCaseDefinitionId());
        User userRep = null;
        if (caseInstance.getStartUserId() != null && (user = this.userCache.getUser(caseInstance.getStartUserId())) != null && user.getUser() != null) {
            userRep = user.getUser();
        }
        CaseInstanceRepresentation caseInstanceResult = new CaseInstanceRepresentation(caseInstance, caseDefinition, caseDefinition.hasGraphicalNotation(), userRep);
        return caseInstanceResult;
    }

    public FormInfo getCaseInstanceStartForm(String caseInstanceId) {
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (!this.permissionService.hasReadPermissionOnCaseInstance(SecurityUtils.getCurrentUserObject(), caseInstance, caseInstanceId)) {
            throw new NotFoundException("Case with id: " + caseInstanceId + " does not exist or is not available for this user");
        }
        return this.cmmnRuntimeService.getStartFormModel(caseInstance.getCaseDefinitionId(), caseInstance.getId());
    }

    public ResultListDataRepresentation getCaseInstanceActiveStages(String caseInstanceId) {
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (!this.permissionService.hasReadPermissionOnCaseInstance(SecurityUtils.getCurrentUserObject(), caseInstance, caseInstanceId)) {
            throw new NotFoundException("Case with id: " + caseInstanceId + " does not exist or is not available for this user");
        }
        ArrayList stages = new ArrayList();
        stages.addAll(this.cmmnHistoryService.createHistoricPlanItemInstanceQuery().planItemInstanceCaseInstanceId(caseInstance.getId()).planItemInstanceDefinitionType(PlanItemDefinitionType.STAGE).planItemInstanceState("available").list());
        stages.addAll(this.cmmnHistoryService.createHistoricPlanItemInstanceQuery().planItemInstanceCaseInstanceId(caseInstance.getId()).planItemInstanceDefinitionType(PlanItemDefinitionType.STAGE).planItemInstanceState("active").list());
        List stageRepresentations = stages.stream().map(p -> new StageRepresentation(p.getName(), p.getState(), p.getCreateTime(), p.getEndedTime())).collect(Collectors.toList());
        return new ResultListDataRepresentation(stageRepresentations);
    }

    public ResultListDataRepresentation getCaseInstanceEndedStages(String caseInstanceId) {
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (!this.permissionService.hasReadPermissionOnCaseInstance(SecurityUtils.getCurrentUserObject(), caseInstance, caseInstanceId)) {
            throw new NotFoundException("Case with id: " + caseInstanceId + " does not exist or is not available for this user");
        }
        ArrayList stages = new ArrayList();
        stages.addAll(this.cmmnHistoryService.createHistoricPlanItemInstanceQuery().planItemInstanceCaseInstanceId(caseInstance.getId()).planItemInstanceDefinitionType(PlanItemDefinitionType.STAGE).planItemInstanceState("terminated").list());
        stages.addAll(this.cmmnHistoryService.createHistoricPlanItemInstanceQuery().planItemInstanceCaseInstanceId(caseInstance.getId()).planItemInstanceDefinitionType(PlanItemDefinitionType.STAGE).planItemInstanceState("completed").list());
        List stageRepresentations = stages.stream().map(p -> new StageRepresentation(p.getName(), p.getState(), p.getCreateTime(), p.getEndedTime())).collect(Collectors.toList());
        return new ResultListDataRepresentation(stageRepresentations);
    }

    public ResultListDataRepresentation getCaseInstanceAvailableMilestones(String caseInstanceId) {
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (!this.permissionService.hasReadPermissionOnCaseInstance(SecurityUtils.getCurrentUserObject(), caseInstance, caseInstanceId)) {
            throw new NotFoundException("Case with id: " + caseInstanceId + " does not exist or is not available for this user");
        }
        ArrayList milestones = new ArrayList();
        milestones.addAll(this.cmmnHistoryService.createHistoricPlanItemInstanceQuery().planItemInstanceCaseInstanceId(caseInstance.getId()).planItemInstanceDefinitionType(PlanItemDefinitionType.MILESTONE).planItemInstanceState("available").list());
        List milestoneRepresentations = milestones.stream().map(p -> new MilestoneRepresentation(p.getName(), p.getState(), p.getCreateTime())).collect(Collectors.toList());
        return new ResultListDataRepresentation(milestoneRepresentations);
    }

    public ResultListDataRepresentation getCaseInstanceEndedMilestones(String caseInstanceId) {
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (!this.permissionService.hasReadPermissionOnCaseInstance(SecurityUtils.getCurrentUserObject(), caseInstance, caseInstanceId)) {
            throw new NotFoundException("Case with id: " + caseInstanceId + " does not exist or is not available for this user");
        }
        ArrayList milestones = new ArrayList();
        milestones.addAll(this.cmmnHistoryService.createHistoricPlanItemInstanceQuery().planItemInstanceCaseInstanceId(caseInstance.getId()).planItemInstanceDefinitionType(PlanItemDefinitionType.MILESTONE).planItemInstanceState("terminated").list());
        milestones.addAll(this.cmmnHistoryService.createHistoricPlanItemInstanceQuery().planItemInstanceCaseInstanceId(caseInstance.getId()).planItemInstanceDefinitionType(PlanItemDefinitionType.MILESTONE).planItemInstanceState("completed").list());
        List milestoneRepresentations = milestones.stream().map(p -> new MilestoneRepresentation(p.getName(), p.getState(), p.getCreateTime())).collect(Collectors.toList());
        return new ResultListDataRepresentation(milestoneRepresentations);
    }

    public CaseInstanceRepresentation startNewCaseInstance(CreateCaseInstanceRepresentation startRequest) {
        UserCache.CachedUser cachedUser;
        if (StringUtils.isEmpty((CharSequence)startRequest.getCaseDefinitionId())) {
            throw new BadRequestException("Case definition id is required");
        }
        CaseDefinition caseDefinition = this.cmmnRepositoryService.getCaseDefinition(startRequest.getCaseDefinitionId());
        CaseInstance caseInstance = this.cmmnRuntimeService.createCaseInstanceBuilder().caseDefinitionId(startRequest.getCaseDefinitionId()).name(startRequest.getName()).outcome(startRequest.getOutcome()).variables(startRequest.getValues()).startWithForm();
        User user = null;
        if (caseInstance.getStartUserId() != null && (cachedUser = this.userCache.getUser(caseInstance.getStartUserId())) != null && cachedUser.getUser() != null) {
            user = cachedUser.getUser();
        }
        return new CaseInstanceRepresentation(caseInstance, caseDefinition, caseDefinition.hasGraphicalNotation(), user);
    }

    public ResultListDataRepresentation getCaseInstanceAvailableUserEventListeners(String caseInstanceId) {
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (!this.permissionService.hasReadPermissionOnCaseInstance(SecurityUtils.getCurrentUserObject(), caseInstance, caseInstanceId)) {
            throw new NotFoundException("Case with id: " + caseInstanceId + " does not exist or is not available for this user");
        }
        ArrayList userEventListenerInstances = new ArrayList();
        userEventListenerInstances.addAll(this.cmmnRuntimeService.createUserEventListenerInstanceQuery().caseInstanceId(caseInstance.getId()).stateAvailable().list());
        userEventListenerInstances.addAll(this.cmmnRuntimeService.createUserEventListenerInstanceQuery().caseInstanceId(caseInstance.getId()).stateSuspended().list());
        List collectedUserEventListenerRepresentations = userEventListenerInstances.stream().map(e -> new UserEventListenerRepresentation(e.getId(), e.getName(), e.getState(), null)).collect(Collectors.toList());
        return new ResultListDataRepresentation(collectedUserEventListenerRepresentations);
    }

    public ResultListDataRepresentation getCaseInstanceCompletedUserEventListeners(String caseInstanceId) {
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (!this.permissionService.hasReadPermissionOnCaseInstance(SecurityUtils.getCurrentUserObject(), caseInstance, caseInstanceId)) {
            throw new NotFoundException("Case with id: " + caseInstanceId + " does not exist or is not available for this user");
        }
        List completedUserEventListeners = this.cmmnHistoryService.createHistoricPlanItemInstanceQuery().planItemInstanceCaseInstanceId(caseInstance.getId()).planItemInstanceDefinitionType(PlanItemDefinitionType.USER_EVENT_LISTENER).planItemInstanceState("completed").list();
        List collectedUserEventListenerRepresentations = completedUserEventListeners.stream().map(e -> new UserEventListenerRepresentation(e.getId(), e.getName(), e.getState(), e.getEndedTime())).collect(Collectors.toList());
        return new ResultListDataRepresentation(collectedUserEventListenerRepresentations);
    }

    public void triggerUserEventListener(String caseInstanceId, String userEventListenerId) {
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        if (!this.permissionService.hasReadPermissionOnCaseInstance(SecurityUtils.getCurrentUserObject(), caseInstance, caseInstanceId)) {
            throw new NotFoundException("Case with id: " + caseInstanceId + " does not exist or is not available for this user");
        }
        if (StringUtils.isEmpty((CharSequence)userEventListenerId)) {
            throw new BadRequestException("User event listener id is required");
        }
        UserEventListenerInstance userEventListenerInstance = (UserEventListenerInstance)this.cmmnRuntimeService.createUserEventListenerInstanceQuery().caseInstanceId(caseInstanceId).id(userEventListenerId).singleResult();
        if (userEventListenerInstance == null) {
            throw new NotFoundException("User event listener not found");
        }
        this.cmmnRuntimeService.completeUserEventListenerInstance(userEventListenerInstance.getId());
    }

    public ResultListDataRepresentation getCaseInstanceEnabledPlanItemInstances(String caseInstanceId) {
        List planItemInstances = this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstanceId).planItemInstanceState("enabled").list();
        ArrayList<PlanItemInstanceRepresentation> representations = new ArrayList<PlanItemInstanceRepresentation>(planItemInstances.size());
        for (PlanItemInstance planItemInstance : planItemInstances) {
            PlanItemInstanceRepresentation planItemInstanceRepresentation = new PlanItemInstanceRepresentation();
            planItemInstanceRepresentation.setId(planItemInstance.getId());
            planItemInstanceRepresentation.setCaseDefinitionId(planItemInstance.getCaseDefinitionId());
            planItemInstanceRepresentation.setCaseInstanceId(planItemInstance.getCaseInstanceId());
            planItemInstanceRepresentation.setStageInstanceId(planItemInstance.getStageInstanceId());
            planItemInstanceRepresentation.setStage(planItemInstance.isStage());
            planItemInstanceRepresentation.setElementId(planItemInstance.getElementId());
            planItemInstanceRepresentation.setPlanItemDefinitionId(planItemInstance.getPlanItemDefinitionId());
            planItemInstanceRepresentation.setPlanItemDefinitionType(planItemInstance.getPlanItemDefinitionType());
            planItemInstanceRepresentation.setName(planItemInstance.getName());
            planItemInstanceRepresentation.setState(planItemInstance.getState());
            planItemInstanceRepresentation.setCreateTime(planItemInstance.getCreateTime());
            representations.add(planItemInstanceRepresentation);
        }
        return new ResultListDataRepresentation(representations);
    }

    public void startEnabledPlanItemInstance(String caseInstanceId, String planItemInstanceId) {
        PlanItemInstance planItemInstance = (PlanItemInstance)this.cmmnRuntimeService.createPlanItemInstanceQuery().caseInstanceId(caseInstanceId).planItemInstanceId(planItemInstanceId).planItemInstanceState("enabled").singleResult();
        if (planItemInstance == null) {
            throw new NotFoundException("No enabled planitem instance found with id " + planItemInstanceId);
        }
        this.cmmnRuntimeService.startPlanItemInstance(planItemInstanceId);
    }

    public void deleteCaseInstance(String caseInstanceId) {
        User currentUser = SecurityUtils.getCurrentUserObject();
        HistoricCaseInstance caseInstance = (HistoricCaseInstance)this.cmmnHistoryService.createHistoricCaseInstanceQuery().caseInstanceId(caseInstanceId).startedBy(String.valueOf(currentUser.getId())).singleResult();
        if (caseInstance == null) {
            throw new NotFoundException("Case with id: " + caseInstanceId + " does not exist or is not started by this user");
        }
        if (caseInstance.getEndTime() != null) {
            this.contentService.deleteContentItemsByScopeIdAndScopeType(caseInstanceId, "cmmn");
            this.cmmnHistoryService.deleteHistoricCaseInstance(caseInstanceId);
        } else {
            this.cmmnRuntimeService.terminateCaseInstance(caseInstanceId);
        }
    }
}

