/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.service.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppDefinition;
import org.flowable.cmmn.api.CmmnHistoryService;
import org.flowable.cmmn.api.CmmnRepositoryService;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.history.HistoricCaseInstanceQuery;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.idm.api.User;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.task.model.runtime.CaseInstanceRepresentation;
import org.flowable.ui.task.service.api.UserCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowableCaseInstanceQueryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowableCaseInstanceQueryService.class);
    private static final int DEFAULT_PAGE_SIZE = 25;
    @Autowired
    protected CmmnRepositoryService cmmnRepositoryService;
    @Autowired
    protected AppRepositoryService appRepositoryService;
    @Autowired
    protected CmmnHistoryService cmmnHistoryService;
    @Autowired
    protected UserCache userCache;

    public ResultListDataRepresentation getCaseInstances(ObjectNode requestNode) {
        JsonNode stateNode;
        JsonNode appDefinitionKeyNode;
        HistoricCaseInstanceQuery instanceQuery = this.cmmnHistoryService.createHistoricCaseInstanceQuery();
        JsonNode caseDefinitionIdNode = requestNode.get("caseDefinitionId");
        if (caseDefinitionIdNode != null && !caseDefinitionIdNode.isNull()) {
            instanceQuery.caseDefinitionId(caseDefinitionIdNode.asText());
        }
        if ((appDefinitionKeyNode = requestNode.get("appDefinitionKey")) != null && !appDefinitionKeyNode.isNull()) {
            List appDefinitions = this.appRepositoryService.createAppDefinitionQuery().appDefinitionKey(appDefinitionKeyNode.asText()).list();
            ArrayList<String> parentDeploymentIds = new ArrayList<String>();
            for (AppDefinition appDefinition : appDefinitions) {
                parentDeploymentIds.add(appDefinition.getDeploymentId());
            }
            List deployments = this.cmmnRepositoryService.createDeploymentQuery().parentDeploymentIds(parentDeploymentIds).list();
            ArrayList<String> deploymentIds = new ArrayList<String>();
            for (CmmnDeployment deployment : deployments) {
                deploymentIds.add(deployment.getId());
            }
            if (deploymentIds.size() > 0) {
                instanceQuery.deploymentIds(deploymentIds);
            } else {
                return new ResultListDataRepresentation(new ArrayList());
            }
        }
        if ((stateNode = requestNode.get("state")) != null && !stateNode.isNull()) {
            String state = stateNode.asText();
            if ("running".equals(state)) {
                instanceQuery.unfinished();
            } else if ("completed".equals(state)) {
                instanceQuery.finished();
            } else if (!"all".equals(state)) {
                throw new BadRequestException("Illegal state filter value passed, only 'running', 'completed' or 'all' are supported");
            }
        } else {
            instanceQuery.unfinished();
        }
        JsonNode sortNode = requestNode.get("sort");
        if (sortNode != null && !sortNode.isNull()) {
            if ("created-desc".equals(sortNode.asText())) {
                instanceQuery.orderByStartTime().desc();
            } else if ("created-asc".equals(sortNode.asText())) {
                instanceQuery.orderByStartTime().asc();
            } else if ("ended-desc".equals(sortNode.asText())) {
                instanceQuery.orderByEndTime().desc();
            } else if ("ended-asc".equals(sortNode.asText())) {
                instanceQuery.orderByEndTime().asc();
            }
        } else {
            instanceQuery.orderByStartTime().desc();
        }
        int page = 0;
        JsonNode pageNode = requestNode.get("page");
        if (pageNode != null && !pageNode.isNull()) {
            page = pageNode.asInt(0);
        }
        int size = 25;
        JsonNode sizeNode = requestNode.get("size");
        if (sizeNode != null && !sizeNode.isNull()) {
            size = sizeNode.asInt(25);
        }
        List instances = instanceQuery.listPage(page * size, size);
        ResultListDataRepresentation result = new ResultListDataRepresentation(this.convertInstanceList(instances));
        if (page != 0 || instances.size() == size) {
            Long totalCount = instanceQuery.count();
            result.setTotal(Long.valueOf(totalCount.intValue()));
            result.setStart(Integer.valueOf(page * size));
        }
        return result;
    }

    protected List<CaseInstanceRepresentation> convertInstanceList(List<HistoricCaseInstance> instances) {
        ArrayList<CaseInstanceRepresentation> result = new ArrayList<CaseInstanceRepresentation>();
        if (CollectionUtils.isNotEmpty(instances)) {
            for (HistoricCaseInstance caseInstance : instances) {
                UserCache.CachedUser user;
                User userRep = null;
                if (caseInstance.getStartUserId() != null && (user = this.userCache.getUser(caseInstance.getStartUserId())) != null && user.getUser() != null) {
                    userRep = user.getUser();
                }
                CaseDefinition caseDefinition = this.cmmnRepositoryService.getCaseDefinition(caseInstance.getCaseDefinitionId());
                CaseInstanceRepresentation instanceRepresentation = new CaseInstanceRepresentation(caseInstance, caseDefinition, caseDefinition.hasGraphicalNotation(), userRep);
                result.add(instanceRepresentation);
            }
        }
        return result;
    }
}

