/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.cmmn.image.impl.DefaultCaseDiagramGenerator;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.dmn.image.impl.DefaultDecisionRequirementsDiagramGenerator;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.image.exception.FlowableImageException;
import org.flowable.image.impl.DefaultProcessDiagramGenerator;

public class ImageGenerator {
    public static BufferedImage createImage(BpmnModel bpmnModel) {
        DefaultProcessDiagramGenerator diagramGenerator = new DefaultProcessDiagramGenerator();
        BufferedImage diagramImage = diagramGenerator.generatePngImage(bpmnModel, 1.0);
        return diagramImage;
    }

    public static BufferedImage createImage(BpmnModel bpmnModel, double scaleFactor) {
        DefaultProcessDiagramGenerator diagramGenerator = new DefaultProcessDiagramGenerator(scaleFactor);
        BufferedImage diagramImage = diagramGenerator.generatePngImage(bpmnModel, scaleFactor);
        return diagramImage;
    }

    public static BufferedImage createCmmnImage(CmmnModel cmmnModel, double scaleFactor) {
        DefaultCaseDiagramGenerator diagramGenerator = new DefaultCaseDiagramGenerator(scaleFactor);
        BufferedImage diagramImage = diagramGenerator.generatePngImage(cmmnModel, scaleFactor);
        return diagramImage;
    }

    public static BufferedImage createDmnImage(DmnDefinition dmnDefinition, double scaleFactor) {
        DefaultDecisionRequirementsDiagramGenerator diagramGenerator = new DefaultDecisionRequirementsDiagramGenerator(scaleFactor);
        BufferedImage diagramImage = diagramGenerator.generatePngImage(dmnDefinition, scaleFactor);
        return diagramImage;
    }

    public static byte[] createByteArrayForImage(BufferedImage image, String imageType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, imageType, out);
        }
        catch (IOException e) {
            throw new FlowableImageException("Error while generating byte array for process image", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
        return out.toByteArray();
    }
}

