/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Base64;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.flowable.idm.api.User;
import org.flowable.ui.common.properties.FlowableCommonAppProperties;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.common.tenant.TenantProvider;
import org.flowable.ui.modeler.domain.AppDefinition;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.properties.FlowableModelerAppProperties;
import org.flowable.ui.modeler.service.BaseAppDefinitionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional
public class AppDefinitionPublishService
extends BaseAppDefinitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppDefinitionPublishService.class);
    protected final FlowableCommonAppProperties properties;
    protected final FlowableModelerAppProperties modelerAppProperties;
    @Autowired
    protected TenantProvider tenantProvider;

    public AppDefinitionPublishService(FlowableCommonAppProperties properties, FlowableModelerAppProperties modelerAppProperties) {
        this.properties = properties;
        this.modelerAppProperties = modelerAppProperties;
    }

    public void publishAppDefinition(String comment, Model appDefinitionModel, User user) {
        byte[] deployZipArtifact;
        this.modelService.createNewModelVersion(appDefinitionModel, comment, user);
        String deployableZipName = appDefinitionModel.getKey() + ".zip";
        AppDefinition appDefinition = null;
        try {
            appDefinition = this.resolveAppDefinition(appDefinitionModel);
        }
        catch (Exception e) {
            LOGGER.error("Error deserializing app {}", (Object)appDefinitionModel.getId(), (Object)e);
            throw new InternalServerErrorException("Could not deserialize app definition");
        }
        if (appDefinition != null && (deployZipArtifact = this.createDeployableZipArtifact(appDefinitionModel, appDefinition)) != null) {
            this.deployZipArtifact(deployableZipName, deployZipArtifact, appDefinitionModel.getKey(), appDefinitionModel.getName());
        }
    }

    protected void deployZipArtifact(String artifactName, byte[] zipArtifact, String deploymentKey, String deploymentName) {
        String deployApiUrl = this.modelerAppProperties.getDeploymentApiUrl();
        Assert.hasText((String)deployApiUrl, (String)"flowable.modeler.app.deployment-api-url must be set");
        String basicAuthUser = this.properties.getIdmAdmin().getUser();
        String basicAuthPassword = this.properties.getIdmAdmin().getPassword();
        String tenantId = this.tenantProvider.getTenantId();
        if (!deployApiUrl.endsWith("/")) {
            deployApiUrl = deployApiUrl.concat("/");
        }
        deployApiUrl = deployApiUrl.concat(String.format("app-repository/deployments?deploymentKey=%s&deploymentName=%s", this.encode(deploymentKey), this.encode(deploymentName)));
        if (tenantId != null) {
            StringBuilder sb = new StringBuilder(deployApiUrl);
            sb.append("&tenantId=").append(this.encode(tenantId));
            deployApiUrl = sb.toString();
        }
        HttpPost httpPost = new HttpPost(deployApiUrl);
        httpPost.setHeader("Authorization", "Basic " + new String(Base64.getEncoder().encode((basicAuthUser + ":" + basicAuthPassword).getBytes(Charset.forName("UTF-8")))));
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        entityBuilder.addBinaryBody("artifact", zipArtifact, ContentType.DEFAULT_BINARY, artifactName);
        HttpEntity entity = entityBuilder.build();
        httpPost.setEntity(entity);
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(builder.build(), new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            }));
        }
        catch (Exception e) {
            LOGGER.error("Could not configure SSL for http client", (Throwable)e);
            throw new InternalServerErrorException("Could not configure SSL for http client", (Throwable)e);
        }
        CloseableHttpClient client = clientBuilder.build();
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() == 201) {
                return;
            }
            try {
                LOGGER.error("Invalid deploy result code: {}", (Object)response.getStatusLine());
                throw new InternalServerErrorException("Invalid deploy result code: " + response.getStatusLine());
            }
            catch (IOException ioe) {
                LOGGER.error("Error calling deploy endpoint", (Throwable)ioe);
                throw new InternalServerErrorException("Error calling deploy endpoint: " + ioe.getMessage());
            }
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Exception while closing http client", (Throwable)e);
                }
            }
        }
    }

    protected String encode(String string) {
        if (string != null) {
            try {
                return URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalStateException("JVM does not support UTF-8 encoding.", uee);
            }
        }
        return null;
    }
}

