/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.rest.app;

import java.util.ArrayList;
import java.util.List;
import org.flowable.idm.api.User;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.idm.model.CreateUserRepresentation;
import org.flowable.ui.idm.model.UpdateUsersRepresentation;
import org.flowable.ui.idm.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class IdmUsersResource {
    @Autowired
    protected UserService userService;

    @RequestMapping(value={"/rest/admin/users"}, method={RequestMethod.GET})
    public ResultListDataRepresentation getUsers(@RequestParam(required=false) String filter, @RequestParam(required=false) String sort, @RequestParam(required=false) Integer start, @RequestParam(required=false) String groupId) {
        int startValue = start != null ? start : 0;
        List users = this.userService.getUsers(filter, sort, start);
        ResultListDataRepresentation result = new ResultListDataRepresentation();
        result.setTotal(Long.valueOf(this.userService.getUserCount(filter, sort, Integer.valueOf(startValue), groupId)));
        result.setStart(Integer.valueOf(startValue));
        result.setSize(Integer.valueOf(users.size()));
        result.setData(this.convertToUserRepresentations(users));
        return result;
    }

    protected List<UserRepresentation> convertToUserRepresentations(List<User> users) {
        ArrayList<UserRepresentation> result = new ArrayList<UserRepresentation>(users.size());
        for (User user : users) {
            result.add(new UserRepresentation(user));
        }
        return result;
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/rest/admin/users/{userId}"}, method={RequestMethod.PUT})
    public void updateUserDetails(@PathVariable String userId, @RequestBody UpdateUsersRepresentation updateUsersRepresentation) {
        this.userService.updateUserDetails(userId, updateUsersRepresentation.getFirstName(), updateUsersRepresentation.getLastName(), updateUsersRepresentation.getEmail(), updateUsersRepresentation.getTenantId());
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/rest/admin/users"}, method={RequestMethod.PUT})
    public void bulkUpdateUserDetails(@RequestBody UpdateUsersRepresentation updateUsersRepresentation) {
        this.userService.bulkUpdatePassword(updateUsersRepresentation.getUsers(), updateUsersRepresentation.getPassword());
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/rest/admin/users/{userId}"}, method={RequestMethod.DELETE})
    public void deleteUser(@PathVariable String userId) {
        this.userService.deleteUser(userId);
    }

    @RequestMapping(value={"/rest/admin/users"}, method={RequestMethod.POST})
    public UserRepresentation createNewUser(@RequestBody CreateUserRepresentation userRepresentation) {
        return new UserRepresentation(this.userService.createNewUser(userRepresentation.getId(), userRepresentation.getFirstName(), userRepresentation.getLastName(), userRepresentation.getEmail(), userRepresentation.getPassword(), userRepresentation.getTenantId()));
    }
}

