/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import javax.servlet.Filter;
import org.flowable.ui.common.properties.FlowableCommonAppProperties;
import org.flowable.ui.common.security.AjaxAuthenticationFailureHandler;
import org.flowable.ui.common.security.AjaxAuthenticationSuccessHandler;
import org.flowable.ui.common.security.FlowableAuthenticationTrustResolver;
import org.flowable.ui.common.security.FlowableLoginUrlAuthenticationEntryPoint;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.PortMapper;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;

public class FlowableUiCustomFormLoginConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<FlowableUiCustomFormLoginConfigurer<H>, H> {
    protected UsernamePasswordAuthenticationFilter authenticationFilter = new UsernamePasswordAuthenticationFilter();
    protected LoginUrlAuthenticationEntryPoint authenticationEntryPoint;

    public FlowableUiCustomFormLoginConfigurer() {
        this.authenticationFilter.setUsernameParameter("j_username");
        this.authenticationFilter.setPasswordParameter("j_password");
        this.authenticationFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)new AjaxAuthenticationSuccessHandler());
        this.authenticationFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)new AjaxAuthenticationFailureHandler());
        this.authenticationFilter.setRequiresAuthenticationRequestMatcher((RequestMatcher)new AntPathRequestMatcher("/app/authentication", "POST"));
    }

    public void init(H builder) throws Exception {
        super.init(builder);
        LoginUrlAuthenticationEntryPoint authenticationEntryPoint = this.getAuthenticationEntryPoint((ApplicationContext)builder.getSharedObject(ApplicationContext.class));
        ExceptionHandlingConfigurer exceptionHandling = (ExceptionHandlingConfigurer)builder.getConfigurer(ExceptionHandlingConfigurer.class);
        if (exceptionHandling != null) {
            LinkedHashMap<RequestMatcher, Object> entryPoints = new LinkedHashMap<RequestMatcher, Object>();
            entryPoints.put(this.getAuthenticationEntryPointMatcher(builder), this.postProcess(authenticationEntryPoint));
            DelegatingAuthenticationEntryPoint delegatingAuthenticationEntryPoint = new DelegatingAuthenticationEntryPoint(entryPoints);
            delegatingAuthenticationEntryPoint.setDefaultEntryPoint((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED));
            exceptionHandling.authenticationEntryPoint((AuthenticationEntryPoint)delegatingAuthenticationEntryPoint);
            exceptionHandling.addObjectPostProcessor((ObjectPostProcessor)new ObjectPostProcessor<ExceptionTranslationFilter>(){

                public <O extends ExceptionTranslationFilter> O postProcess(O object) {
                    object.setAuthenticationTrustResolver((AuthenticationTrustResolver)new FlowableAuthenticationTrustResolver());
                    return object;
                }
            });
        }
    }

    protected RequestMatcher getAuthenticationEntryPointMatcher(H http) {
        ContentNegotiationStrategy contentNegotiationStrategy = (ContentNegotiationStrategy)http.getSharedObject(ContentNegotiationStrategy.class);
        if (contentNegotiationStrategy == null) {
            contentNegotiationStrategy = new HeaderContentNegotiationStrategy();
        }
        MediaTypeRequestMatcher mediaMatcher = new MediaTypeRequestMatcher(contentNegotiationStrategy, new MediaType[]{MediaType.APPLICATION_XHTML_XML, new MediaType("image", "*"), MediaType.TEXT_HTML, MediaType.TEXT_PLAIN});
        mediaMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        NegatedRequestMatcher notXRequestedWith = new NegatedRequestMatcher((RequestMatcher)new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest"));
        return new AndRequestMatcher(Arrays.asList(notXRequestedWith, mediaMatcher));
    }

    protected LoginUrlAuthenticationEntryPoint getAuthenticationEntryPoint(ApplicationContext applicationContext) {
        if (this.authenticationEntryPoint == null) {
            FlowableCommonAppProperties commonAppProperties = (FlowableCommonAppProperties)applicationContext.getBean(FlowableCommonAppProperties.class);
            if (ClassUtils.isPresent((String)"org.flowable.ui.idm.service.GroupServiceImpl", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())) {
                this.authenticationEntryPoint = (LoginUrlAuthenticationEntryPoint)this.postProcess(new LoginUrlAuthenticationEntryPoint("/idm/#/login"));
            } else {
                String redirectOnAuthSuccess = commonAppProperties.getRedirectOnAuthSuccess();
                String idmAppUrl = commonAppProperties.determineIdmAppRedirectUrl();
                this.authenticationEntryPoint = (LoginUrlAuthenticationEntryPoint)this.postProcess((Object)new FlowableLoginUrlAuthenticationEntryPoint(idmAppUrl, redirectOnAuthSuccess));
            }
        }
        return this.authenticationEntryPoint;
    }

    public void configure(H builder) throws Exception {
        RememberMeServices rememberMeServices;
        PortMapper portMapper = (PortMapper)builder.getSharedObject(PortMapper.class);
        if (portMapper != null) {
            this.getAuthenticationEntryPoint((ApplicationContext)builder.getSharedObject(ApplicationContext.class)).setPortMapper(portMapper);
        }
        this.authenticationFilter.setAuthenticationManager((AuthenticationManager)builder.getSharedObject(AuthenticationManager.class));
        SessionAuthenticationStrategy sessionAuthenticationStrategy = (SessionAuthenticationStrategy)builder.getSharedObject(SessionAuthenticationStrategy.class);
        if (sessionAuthenticationStrategy != null) {
            this.authenticationFilter.setSessionAuthenticationStrategy(sessionAuthenticationStrategy);
        }
        if ((rememberMeServices = (RememberMeServices)builder.getSharedObject(RememberMeServices.class)) != null) {
            this.authenticationFilter.setRememberMeServices(rememberMeServices);
        }
        builder.addFilter((Filter)this.postProcess(this.authenticationFilter));
    }
}

