/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="flowable.common.app")
public class FlowableCommonAppProperties {
    private String tenantId;
    private String rolePrefix = "ROLE_";
    private String idmUrl;
    private String idmRedirectUrl;
    private String redirectOnAuthSuccess;
    @NestedConfigurationProperty
    private final Cache cacheLoginTokens = new Cache();
    @NestedConfigurationProperty
    private final Cache cacheLoginUsers = new Cache();
    @NestedConfigurationProperty
    private final Cache cacheUsers = new Cache();
    @NestedConfigurationProperty
    private final Admin idmAdmin = new Admin();

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public String getIdmUrl() {
        return this.idmUrl;
    }

    public void setIdmUrl(String idmUrl) {
        this.idmUrl = idmUrl;
    }

    public String getIdmRedirectUrl() {
        return this.idmRedirectUrl;
    }

    public void setIdmRedirectUrl(String idmRedirectUrl) {
        this.idmRedirectUrl = idmRedirectUrl;
    }

    public String getRedirectOnAuthSuccess() {
        return this.redirectOnAuthSuccess;
    }

    public void setRedirectOnAuthSuccess(String redirectOnAuthSuccess) {
        this.redirectOnAuthSuccess = redirectOnAuthSuccess;
    }

    public Cache getCacheLoginTokens() {
        return this.cacheLoginTokens;
    }

    public Cache getCacheLoginUsers() {
        return this.cacheLoginUsers;
    }

    public Cache getCacheUsers() {
        return this.cacheUsers;
    }

    public Admin getIdmAdmin() {
        return this.idmAdmin;
    }

    public String determineIdmAppUrl() {
        String idmAppUrl = this.getIdmUrl();
        Assert.hasText((String)idmAppUrl, (String)"`flowable.common.app.idm-url` must be set");
        if (!idmAppUrl.endsWith("/")) {
            idmAppUrl = idmAppUrl + "/";
        }
        return idmAppUrl;
    }

    public String determineIdmAppRedirectUrl() {
        String idmAppRedirectUrl = this.getIdmRedirectUrl();
        if (idmAppRedirectUrl != null && idmAppRedirectUrl.length() > 0) {
            if (!idmAppRedirectUrl.endsWith("/")) {
                idmAppRedirectUrl = idmAppRedirectUrl + "/";
            }
            return idmAppRedirectUrl;
        }
        return this.determineIdmAppUrl();
    }

    public static class Admin {
        private String user = "admin";
        private String password;

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class Cache {
        private long maxSize = 2048L;
        private long maxAge = 30L;

        public long getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(long maxSize) {
            this.maxSize = maxSize;
        }

        public long getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(long maxAge) {
            this.maxAge = maxAge;
        }
    }
}

