/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.task.service.impl.util;

import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.task.service.impl.persistence.CountingTaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.util.CommandContextUtil;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.service.event.impl.FlowableVariableEventBuilder;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class CountingTaskUtil {
    public static void handleDeleteVariableInstanceEntityCount(VariableInstanceEntity variableInstance, boolean fireDeleteEvent) {
        CountingTaskEntity countingTaskEntity;
        if (variableInstance.getTaskId() != null && CountingTaskUtil.isTaskRelatedEntityCountEnabledGlobally() && CountingTaskUtil.isTaskRelatedEntityCountEnabled(countingTaskEntity = (CountingTaskEntity)CommandContextUtil.getTaskEntityManager().findById(variableInstance.getTaskId()))) {
            countingTaskEntity.setVariableCount(countingTaskEntity.getVariableCount() - 1);
        }
        FlowableEventDispatcher eventDispatcher = CommandContextUtil.getTaskServiceConfiguration().getEventDispatcher();
        if (fireDeleteEvent && eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableVariableEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.ENTITY_DELETED, (Object)variableInstance));
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableVariableEventBuilder.createVariableEvent((FlowableEngineEventType)FlowableEngineEventType.VARIABLE_DELETED, (String)variableInstance.getName(), null, (VariableType)variableInstance.getType(), (String)variableInstance.getTaskId(), (String)variableInstance.getExecutionId(), (String)variableInstance.getProcessInstanceId(), (String)variableInstance.getProcessDefinitionId(), (String)variableInstance.getScopeId(), (String)variableInstance.getScopeType()));
        }
    }

    public static void handleInsertVariableInstanceEntityCount(VariableInstanceEntity variableInstance) {
        CountingTaskEntity countingTaskEntity;
        if (variableInstance.getTaskId() != null && CountingTaskUtil.isTaskRelatedEntityCountEnabledGlobally() && CountingTaskUtil.isTaskRelatedEntityCountEnabled(countingTaskEntity = (CountingTaskEntity)CommandContextUtil.getTaskEntityManager().findById(variableInstance.getTaskId()))) {
            countingTaskEntity.setVariableCount(countingTaskEntity.getVariableCount() + 1);
        }
    }

    public static boolean isTaskRelatedEntityCountEnabledGlobally() {
        if (CommandContextUtil.getTaskServiceConfiguration() == null) {
            return false;
        }
        return CommandContextUtil.getTaskServiceConfiguration().isEnableTaskRelationshipCounts();
    }

    public static boolean isTaskRelatedEntityCountEnabled(TaskEntity taskEntity) {
        if (taskEntity instanceof CountingTaskEntity) {
            return CountingTaskUtil.isTaskRelatedEntityCountEnabled((CountingTaskEntity)((Object)taskEntity));
        }
        return false;
    }

    public static boolean isTaskRelatedEntityCountEnabled(CountingTaskEntity taskEntity) {
        return CountingTaskUtil.isTaskRelatedEntityCountEnabledGlobally() && taskEntity.isCountEnabled();
    }
}

