/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.security;

import java.util.ArrayList;
import java.util.List;
import org.flowable.engine.IdentityService;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.idm.api.Group;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class IdentityServiceUserDetailsService
implements UserDetailsService {
    private final IdentityService identityService;

    public IdentityServiceUserDetailsService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public UserDetails loadUserByUsername(String userId) throws UsernameNotFoundException {
        org.flowable.idm.api.User user = null;
        try {
            user = (org.flowable.idm.api.User)this.identityService.createUserQuery().userId(userId).singleResult();
        }
        catch (FlowableException flowableException) {
            // empty catch block
        }
        if (null == user) {
            throw new UsernameNotFoundException(String.format("user (%s) could not be found", userId));
        }
        boolean active = true;
        ArrayList<GroupGrantedAuthority> grantedAuthorityList = new ArrayList<GroupGrantedAuthority>();
        List groupsForUser = this.identityService.createGroupQuery().groupMember(user.getId()).list();
        for (Group g : groupsForUser) {
            grantedAuthorityList.add(new GroupGrantedAuthority(g));
        }
        return new User(user.getId(), user.getPassword(), active, active, active, active, grantedAuthorityList);
    }

    public static class GroupGrantedAuthority
    implements GrantedAuthority {
        private final Group group;

        public GroupGrantedAuthority(Group group) {
            this.group = group;
        }

        public Group getGroup() {
            return this.group;
        }

        public String getAuthority() {
            return this.group.getName();
        }
    }
}

