/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.flowable.common.rest.exception.BaseExceptionHandlerAdvice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration(proxyBeanMethods=false)
@ComponentScan(basePackageClasses={BaseExceptionHandlerAdvice.class})
@ConditionalOnClass(value={WebMvcConfigurationSupport.class})
@EnableAsync
public class DispatcherServletConfiguration
extends WebMvcConfigurationSupport {
    @Autowired
    protected ObjectMapper objectMapper;

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        this.addDefaultHttpMessageConverters(converters);
        for (HttpMessageConverter<?> converter : converters) {
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            MappingJackson2HttpMessageConverter jackson2HttpMessageConverter = (MappingJackson2HttpMessageConverter)converter;
            jackson2HttpMessageConverter.setObjectMapper(this.objectMapper);
            break;
        }
    }
}

