/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.flowable.app.spring.SpringAppEngineConfiguration;
import org.flowable.common.engine.api.async.AsyncTaskExecutor;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.EngineConfigurator;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.common.engine.impl.persistence.StrongUuidGenerator;
import org.flowable.common.spring.AutoDeploymentStrategy;
import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.flowable.common.spring.SpringEngineConfiguration;
import org.flowable.common.spring.async.SpringAsyncTaskExecutor;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.configurator.ProcessEngineConfigurator;
import org.flowable.engine.spring.configurator.SpringProcessEngineConfigurator;
import org.flowable.http.common.api.client.FlowableHttpClient;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.AsyncJobExecutorConfiguration;
import org.flowable.spring.SpringProcessEngineConfiguration;
import org.flowable.spring.boot.AbstractSpringEngineAutoConfiguration;
import org.flowable.spring.boot.BaseEngineConfigurationWithConfigurers;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.flowable.spring.boot.FlowableAutoDeploymentProperties;
import org.flowable.spring.boot.FlowableHttpProperties;
import org.flowable.spring.boot.FlowableJobConfiguration;
import org.flowable.spring.boot.FlowableJpaAutoConfiguration;
import org.flowable.spring.boot.FlowableMailProperties;
import org.flowable.spring.boot.FlowableProperties;
import org.flowable.spring.boot.app.AppEngineAutoConfiguration;
import org.flowable.spring.boot.app.AppEngineServicesAutoConfiguration;
import org.flowable.spring.boot.app.FlowableAppProperties;
import org.flowable.spring.boot.condition.ConditionalOnProcessEngine;
import org.flowable.spring.boot.eventregistry.FlowableEventRegistryProperties;
import org.flowable.spring.boot.idm.FlowableIdmProperties;
import org.flowable.spring.boot.process.FlowableProcessProperties;
import org.flowable.spring.boot.process.Process;
import org.flowable.spring.boot.process.ProcessAsync;
import org.flowable.spring.boot.process.ProcessAsyncHistory;
import org.flowable.spring.configurator.DefaultAutoDeploymentStrategy;
import org.flowable.spring.configurator.ResourceParentFolderAutoDeploymentStrategy;
import org.flowable.spring.configurator.SingleResourceAutoDeploymentStrategy;
import org.flowable.spring.job.service.SpringAsyncExecutor;
import org.flowable.spring.job.service.SpringAsyncHistoryExecutor;
import org.flowable.spring.job.service.SpringRejectedJobsHandler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.Resource;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;

@ConditionalOnProcessEngine
@EnableConfigurationProperties(value={FlowableAutoDeploymentProperties.class, FlowableProperties.class, FlowableMailProperties.class, FlowableHttpProperties.class, FlowableProcessProperties.class, FlowableAppProperties.class, FlowableIdmProperties.class, FlowableEventRegistryProperties.class})
@AutoConfiguration(after={FlowableJpaAutoConfiguration.class, AppEngineAutoConfiguration.class, TaskExecutionAutoConfiguration.class}, before={AppEngineServicesAutoConfiguration.class})
@Import(value={FlowableJobConfiguration.class})
public class ProcessEngineAutoConfiguration
extends AbstractSpringEngineAutoConfiguration {
    protected final FlowableProcessProperties processProperties;
    protected final FlowableAppProperties appProperties;
    protected final FlowableIdmProperties idmProperties;
    protected final FlowableEventRegistryProperties eventProperties;
    protected final FlowableMailProperties mailProperties;
    protected final FlowableHttpProperties httpProperties;
    protected final FlowableAutoDeploymentProperties autoDeploymentProperties;

    public ProcessEngineAutoConfiguration(FlowableProperties flowableProperties, FlowableProcessProperties processProperties, FlowableAppProperties appProperties, FlowableIdmProperties idmProperties, FlowableEventRegistryProperties eventProperties, FlowableMailProperties mailProperties, FlowableHttpProperties httpProperties, FlowableAutoDeploymentProperties autoDeploymentProperties) {
        super(flowableProperties);
        this.processProperties = processProperties;
        this.appProperties = appProperties;
        this.idmProperties = idmProperties;
        this.eventProperties = eventProperties;
        this.mailProperties = mailProperties;
        this.httpProperties = httpProperties;
        this.autoDeploymentProperties = autoDeploymentProperties;
    }

    @Bean
    @ProcessAsync
    @ConfigurationProperties(prefix="flowable.process.async.executor")
    public AsyncJobExecutorConfiguration processAsyncExecutorConfiguration() {
        return new AsyncJobExecutorConfiguration();
    }

    @Bean
    @ProcessAsync
    @ConditionalOnMissingBean(name={"processAsyncExecutor"})
    public SpringAsyncExecutor processAsyncExecutor(@ProcessAsync AsyncJobExecutorConfiguration executorConfiguration, ObjectProvider<SpringRejectedJobsHandler> rejectedJobsHandler, @Process ObjectProvider<SpringRejectedJobsHandler> processRejectedJobsHandler) {
        SpringAsyncExecutor asyncExecutor = new SpringAsyncExecutor(executorConfiguration);
        asyncExecutor.setRejectedJobsHandler(this.getIfAvailable(processRejectedJobsHandler, rejectedJobsHandler));
        return asyncExecutor;
    }

    @Bean
    @ProcessAsyncHistory
    @ConfigurationProperties(prefix="flowable.process.async-history.executor")
    @ConditionalOnProperty(prefix="flowable.process", name={"async-history.enable"})
    public AsyncJobExecutorConfiguration processAsyncHistoryExecutorConfiguration() {
        return new AsyncJobExecutorConfiguration();
    }

    @Bean
    @ProcessAsyncHistory
    @ConditionalOnMissingBean(name={"asyncHistoryExecutor"})
    @ConditionalOnProperty(prefix="flowable.process", name={"async-history.enable"})
    public SpringAsyncHistoryExecutor asyncHistoryExecutor(@ProcessAsyncHistory AsyncJobExecutorConfiguration executorConfiguration, ObjectProvider<SpringRejectedJobsHandler> rejectedJobsHandler, @Process ObjectProvider<SpringRejectedJobsHandler> processRejectedJobsHandler) {
        SpringAsyncHistoryExecutor asyncHistoryExecutor = new SpringAsyncHistoryExecutor(executorConfiguration);
        asyncHistoryExecutor.setRejectedJobsHandler(this.getIfAvailable(processRejectedJobsHandler, rejectedJobsHandler));
        return asyncHistoryExecutor;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringProcessEngineConfiguration springProcessEngineConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager, ObjectProvider<ObjectMapper> objectMapperProvider, @Process ObjectProvider<IdGenerator> processIdGenerator, ObjectProvider<IdGenerator> globalIdGenerator, @ProcessAsync ObjectProvider<AsyncExecutor> asyncExecutorProvider, @Qualifier(value="applicationTaskExecutor") ObjectProvider<AsyncListenableTaskExecutor> applicationTaskExecutorProvider, @ProcessAsyncHistory ObjectProvider<AsyncExecutor> asyncHistoryExecutorProvider, ObjectProvider<AsyncListenableTaskExecutor> taskExecutor, @Process ObjectProvider<AsyncListenableTaskExecutor> processTaskExecutor, @Qualifier(value="flowableAsyncTaskInvokerTaskExecutor") ObjectProvider<AsyncTaskExecutor> asyncTaskInvokerTaskExecutor, ObjectProvider<FlowableHttpClient> flowableHttpClient, ObjectProvider<AutoDeploymentStrategy<ProcessEngine>> processEngineAutoDeploymentStrategies) throws IOException {
        AsyncExecutor springAsyncHistoryExecutor;
        AsyncListenableTaskExecutor asyncTaskExecutor;
        AsyncExecutor springAsyncExecutor;
        SpringProcessEngineConfiguration conf = new SpringProcessEngineConfiguration();
        List<Resource> resources = this.discoverDeploymentResources(this.flowableProperties.getProcessDefinitionLocationPrefix(), this.flowableProperties.getProcessDefinitionLocationSuffixes(), this.flowableProperties.isCheckProcessDefinitions());
        if (resources != null && !resources.isEmpty()) {
            conf.setDeploymentResources(resources.toArray(new Resource[0]));
            conf.setDeploymentName(this.flowableProperties.getDeploymentName());
        }
        if ((springAsyncExecutor = (AsyncExecutor)asyncExecutorProvider.getIfUnique()) != null) {
            conf.setAsyncExecutor(springAsyncExecutor);
        }
        if ((asyncTaskExecutor = this.getIfAvailable(processTaskExecutor, taskExecutor)) == null) {
            asyncTaskExecutor = (AsyncListenableTaskExecutor)applicationTaskExecutorProvider.getObject();
        }
        if (asyncTaskExecutor != null) {
            SpringAsyncTaskExecutor flowableTaskExecutor = new SpringAsyncTaskExecutor(asyncTaskExecutor);
            conf.setAsyncTaskExecutor((AsyncTaskExecutor)flowableTaskExecutor);
            conf.setAsyncHistoryTaskExecutor((AsyncTaskExecutor)flowableTaskExecutor);
        }
        if ((springAsyncHistoryExecutor = (AsyncExecutor)asyncHistoryExecutorProvider.getIfUnique()) != null) {
            conf.setAsyncHistoryEnabled(true);
            conf.setAsyncHistoryExecutor(springAsyncHistoryExecutor);
        }
        asyncTaskInvokerTaskExecutor.ifAvailable(arg_0 -> ((SpringProcessEngineConfiguration)conf).setAsyncTaskInvokerTaskExecutor(arg_0));
        objectMapperProvider.ifAvailable(arg_0 -> ((SpringProcessEngineConfiguration)conf).setObjectMapper(arg_0));
        this.configureSpringEngine((SpringEngineConfiguration)conf, platformTransactionManager);
        this.configureEngine((AbstractEngineConfiguration)conf, dataSource);
        conf.setDeploymentName(this.defaultText(this.flowableProperties.getDeploymentName(), conf.getDeploymentName()));
        conf.setDisableIdmEngine(!this.flowableProperties.isDbIdentityUsed() || !this.idmProperties.isEnabled());
        conf.setDisableEventRegistry(!this.eventProperties.isEnabled());
        conf.setAsyncExecutorActivate(this.flowableProperties.isAsyncExecutorActivate());
        conf.setAsyncHistoryExecutorActivate(this.flowableProperties.isAsyncHistoryExecutorActivate());
        conf.setMailServerHost(this.mailProperties.getHost());
        conf.setMailServerPort(this.mailProperties.getPort());
        conf.setMailServerSSLPort(this.mailProperties.getSSLPort());
        conf.setMailServerUsername(this.mailProperties.getUsername());
        conf.setMailServerPassword(this.mailProperties.getPassword());
        conf.setMailServerDefaultFrom(this.mailProperties.getDefaultFrom());
        conf.setMailServerForceTo(this.mailProperties.getForceTo());
        conf.setMailServerUseSSL(this.mailProperties.isUseSsl());
        conf.setMailServerUseTLS(this.mailProperties.isUseTls());
        conf.setMailServerDefaultCharset(this.mailProperties.getDefaultCharset());
        conf.getHttpClientConfig().setUseSystemProperties(this.httpProperties.isUseSystemProperties());
        conf.getHttpClientConfig().setConnectionRequestTimeout(this.httpProperties.getConnectionRequestTimeout());
        conf.getHttpClientConfig().setConnectTimeout(this.httpProperties.getConnectTimeout());
        conf.getHttpClientConfig().setDisableCertVerify(this.httpProperties.isDisableCertVerify());
        conf.getHttpClientConfig().setRequestRetryLimit(this.httpProperties.getRequestRetryLimit());
        conf.getHttpClientConfig().setSocketTimeout(this.httpProperties.getSocketTimeout());
        conf.getHttpClientConfig().setHttpClient((FlowableHttpClient)flowableHttpClient.getIfAvailable());
        conf.setEnableProcessDefinitionHistoryLevel(this.processProperties.isEnableProcessDefinitionHistoryLevel());
        conf.setProcessDefinitionCacheLimit(this.processProperties.getDefinitionCacheLimit());
        conf.setEnableSafeBpmnXml(this.processProperties.isEnableSafeXml());
        conf.setEventRegistryStartProcessInstanceAsync(this.processProperties.isEventRegistryStartProcessInstanceAsync());
        conf.setEventRegistryUniqueProcessInstanceCheckWithLock(this.processProperties.isEventRegistryUniqueProcessInstanceCheckWithLock());
        conf.setEventRegistryUniqueProcessInstanceStartLockTime(this.processProperties.getEventRegistryUniqueProcessInstanceStartLockTime());
        conf.setHistoryLevel(this.flowableProperties.getHistoryLevel());
        conf.setActivityFontName(this.flowableProperties.getActivityFontName());
        conf.setAnnotationFontName(this.flowableProperties.getAnnotationFontName());
        conf.setLabelFontName(this.flowableProperties.getLabelFontName());
        conf.setFormFieldValidationEnabled(this.flowableProperties.isFormFieldValidationEnabled());
        conf.setEnableHistoryCleaning(this.flowableProperties.isEnableHistoryCleaning());
        conf.setHistoryCleaningTimeCycleConfig(this.flowableProperties.getHistoryCleaningCycle());
        conf.setCleanInstancesEndedAfter(this.flowableProperties.getHistoryCleaningAfter());
        conf.setCleanInstancesBatchSize(this.flowableProperties.getHistoryCleaningBatchSize());
        IdGenerator idGenerator = this.getIfAvailable(processIdGenerator, globalIdGenerator);
        if (idGenerator == null) {
            idGenerator = new StrongUuidGenerator();
        }
        conf.setIdGenerator(idGenerator);
        List deploymentStrategies = processEngineAutoDeploymentStrategies.orderedStream().collect(Collectors.toList());
        CommonAutoDeploymentProperties deploymentProperties = this.autoDeploymentProperties.deploymentPropertiesForEngine("bpmn");
        deploymentStrategies.add(new DefaultAutoDeploymentStrategy(deploymentProperties));
        deploymentStrategies.add(new SingleResourceAutoDeploymentStrategy(deploymentProperties));
        deploymentStrategies.add(new ResourceParentFolderAutoDeploymentStrategy(deploymentProperties));
        conf.setDeploymentStrategies(deploymentStrategies);
        return conf;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(type={"org.flowable.app.spring.SpringAppEngineConfiguration"})
    public static class ProcessEngineAppConfiguration
    extends BaseEngineConfigurationWithConfigurers<SpringProcessEngineConfiguration> {
        @Bean
        @ConditionalOnMissingBean(name={"processAppEngineConfigurationConfigurer"})
        public EngineConfigurationConfigurer<SpringAppEngineConfiguration> processAppEngineConfigurationConfigurer(ProcessEngineConfigurator processEngineConfigurator) {
            return appEngineConfiguration -> appEngineConfiguration.addConfigurator((EngineConfigurator)processEngineConfigurator);
        }

        @Bean
        @ConditionalOnMissingBean
        public ProcessEngineConfigurator processEngineConfigurator(SpringProcessEngineConfiguration processEngineConfiguration) {
            SpringProcessEngineConfigurator processEngineConfigurator = new SpringProcessEngineConfigurator();
            processEngineConfigurator.setProcessEngineConfiguration(processEngineConfiguration);
            processEngineConfiguration.setDisableIdmEngine(true);
            processEngineConfiguration.setDisableEventRegistry(true);
            this.invokeConfigurers(processEngineConfiguration);
            return processEngineConfigurator;
        }
    }
}

