/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.boot.ldap;

import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.spring.SpringIdmEngineConfiguration;
import org.flowable.ldap.LDAPConfiguration;
import org.flowable.ldap.LDAPGroupCache;
import org.flowable.ldap.LDAPIdentityServiceImpl;
import org.flowable.ldap.LDAPQueryBuilder;
import org.flowable.spring.boot.EngineConfigurationConfigurer;
import org.flowable.spring.boot.FlowableSecurityAutoConfiguration;
import org.flowable.spring.boot.ProcessEngineServicesAutoConfiguration;
import org.flowable.spring.boot.condition.ConditionalOnLdap;
import org.flowable.spring.boot.idm.IdmEngineServicesAutoConfiguration;
import org.flowable.spring.boot.ldap.FlowableLdapProperties;
import org.flowable.spring.security.FlowableAuthenticationProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.userdetails.UserDetailsService;

@ConditionalOnLdap
@AutoConfigureBefore(value={FlowableSecurityAutoConfiguration.class, IdmEngineServicesAutoConfiguration.class, ProcessEngineServicesAutoConfiguration.class})
@EnableConfigurationProperties(value={FlowableLdapProperties.class})
@Configuration(proxyBeanMethods=false)
public class FlowableLdapAutoConfiguration {
    protected final FlowableLdapProperties properties;
    protected final LDAPQueryBuilder ldapQueryBuilder;
    protected final LDAPGroupCache.LDAPGroupCacheListener ldapGroupCacheListener;

    public FlowableLdapAutoConfiguration(FlowableLdapProperties properties, ObjectProvider<LDAPQueryBuilder> ldapQueryBuilder, ObjectProvider<LDAPGroupCache.LDAPGroupCacheListener> ldapGroupCacheListener) {
        this.properties = properties;
        this.ldapQueryBuilder = (LDAPQueryBuilder)ldapQueryBuilder.getIfAvailable();
        this.ldapGroupCacheListener = (LDAPGroupCache.LDAPGroupCacheListener)ldapGroupCacheListener.getIfAvailable();
    }

    @Bean
    @ConditionalOnMissingBean
    public LDAPConfiguration ldapConfiguration() {
        LDAPConfiguration ldapConfiguration = new LDAPConfiguration();
        this.properties.customize(ldapConfiguration);
        if (this.ldapQueryBuilder != null) {
            ldapConfiguration.setLdapQueryBuilder(this.ldapQueryBuilder);
        }
        if (this.ldapGroupCacheListener != null) {
            ldapConfiguration.setGroupCacheListener(this.ldapGroupCacheListener);
        }
        return ldapConfiguration;
    }

    @Bean
    public EngineConfigurationConfigurer<SpringIdmEngineConfiguration> ldapIdmEngineConfigurer(LDAPConfiguration ldapConfiguration) {
        return idmEngineConfiguration -> idmEngineConfiguration.setIdmIdentityService((IdmIdentityService)new LDAPIdentityServiceImpl(ldapConfiguration, this.createCache((SpringIdmEngineConfiguration)idmEngineConfiguration, ldapConfiguration), (IdmEngineConfiguration)idmEngineConfiguration));
    }

    @Bean
    @ConditionalOnMissingBean(value={AuthenticationProvider.class})
    public FlowableAuthenticationProvider flowableAuthenticationProvider(IdmIdentityService idmIdentitySerivce, UserDetailsService userDetailsService) {
        return new FlowableAuthenticationProvider(idmIdentitySerivce, userDetailsService);
    }

    protected LDAPGroupCache createCache(SpringIdmEngineConfiguration engineConfiguration, LDAPConfiguration ldapConfiguration) {
        LDAPGroupCache ldapGroupCache = null;
        if (ldapConfiguration.getGroupCacheSize() > 0) {
            ldapGroupCache = new LDAPGroupCache(ldapConfiguration.getGroupCacheSize(), ldapConfiguration.getGroupCacheExpirationTime(), () -> ((SpringIdmEngineConfiguration)engineConfiguration).getClock());
            if (ldapConfiguration.getGroupCacheListener() != null) {
                ldapGroupCache.setLdapCacheListener(ldapConfiguration.getGroupCacheListener());
            }
        }
        return ldapGroupCache;
    }
}

