/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring;

import java.util.ArrayList;
import java.util.Collection;
import javax.sql.DataSource;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.ProcessEngines;
import org.flowable.engine.cfg.ProcessEngineConfigurator;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.common.impl.interceptor.CommandInterceptor;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.flowable.engine.impl.variable.EntityManagerSession;
import org.flowable.spring.SpringEntityManagerSessionFactory;
import org.flowable.spring.SpringTransactionContextFactory;
import org.flowable.spring.SpringTransactionInterceptor;
import org.flowable.spring.autodeployment.AutoDeploymentStrategy;
import org.flowable.spring.autodeployment.DefaultAutoDeploymentStrategy;
import org.flowable.spring.autodeployment.ResourceParentFolderAutoDeploymentStrategy;
import org.flowable.spring.autodeployment.SingleResourceAutoDeploymentStrategy;
import org.flowable.spring.configurator.SpringIdmEngineConfigurator;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

public class SpringProcessEngineConfiguration
extends ProcessEngineConfigurationImpl
implements ApplicationContextAware {
    protected PlatformTransactionManager transactionManager;
    protected String deploymentName = "SpringAutoDeployment";
    protected Resource[] deploymentResources = new Resource[0];
    protected String deploymentMode = "default";
    protected ApplicationContext applicationContext;
    protected Integer transactionSynchronizationAdapterOrder;
    private Collection<AutoDeploymentStrategy> deploymentStrategies = new ArrayList<AutoDeploymentStrategy>();

    public SpringProcessEngineConfiguration() {
        this.transactionsExternallyManaged = true;
        this.deploymentStrategies.add(new DefaultAutoDeploymentStrategy());
        this.deploymentStrategies.add(new SingleResourceAutoDeploymentStrategy());
        this.deploymentStrategies.add(new ResourceParentFolderAutoDeploymentStrategy());
        this.setIdmProcessEngineConfigurator((ProcessEngineConfigurator)new SpringIdmEngineConfigurator());
    }

    public ProcessEngine buildProcessEngine() {
        ProcessEngine processEngine = super.buildProcessEngine();
        ProcessEngines.setInitialized((boolean)true);
        this.autoDeployResources(processEngine);
        return processEngine;
    }

    public void setTransactionSynchronizationAdapterOrder(Integer transactionSynchronizationAdapterOrder) {
        this.transactionSynchronizationAdapterOrder = transactionSynchronizationAdapterOrder;
    }

    public void initDefaultCommandConfig() {
        if (this.defaultCommandConfig == null) {
            this.defaultCommandConfig = new CommandConfig().setContextReusePossible(true);
        }
    }

    public CommandInterceptor createTransactionInterceptor() {
        if (this.transactionManager == null) {
            throw new FlowableException("transactionManager is required property for SpringProcessEngineConfiguration, use " + StandaloneProcessEngineConfiguration.class.getName() + " otherwise");
        }
        return new SpringTransactionInterceptor(this.transactionManager);
    }

    public void initTransactionContextFactory() {
        if (this.transactionContextFactory == null && this.transactionManager != null) {
            this.transactionContextFactory = new SpringTransactionContextFactory(this.transactionManager, this.transactionSynchronizationAdapterOrder);
        }
    }

    public void initJpa() {
        super.initJpa();
        if (this.jpaEntityManagerFactory != null) {
            this.sessionFactories.put(EntityManagerSession.class, new SpringEntityManagerSessionFactory(this.jpaEntityManagerFactory, this.jpaHandleTransaction, this.jpaCloseEntityManager));
        }
    }

    protected void autoDeployResources(ProcessEngine processEngine) {
        if (this.deploymentResources != null && this.deploymentResources.length > 0) {
            AutoDeploymentStrategy strategy = this.getAutoDeploymentStrategy(this.deploymentMode);
            strategy.deployResources(this.deploymentName, this.deploymentResources, processEngine.getRepositoryService());
        }
    }

    public ProcessEngineConfiguration setDataSource(DataSource dataSource) {
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            return super.setDataSource(dataSource);
        }
        TransactionAwareDataSourceProxy proxiedDataSource = new TransactionAwareDataSourceProxy(dataSource);
        return super.setDataSource((DataSource)proxiedDataSource);
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public Resource[] getDeploymentResources() {
        return this.deploymentResources;
    }

    public void setDeploymentResources(Resource[] deploymentResources) {
        this.deploymentResources = deploymentResources;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(String deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    protected AutoDeploymentStrategy getAutoDeploymentStrategy(String mode) {
        AutoDeploymentStrategy result = new DefaultAutoDeploymentStrategy();
        for (AutoDeploymentStrategy strategy : this.deploymentStrategies) {
            if (!strategy.handlesMode(mode)) continue;
            result = strategy;
            break;
        }
        return result;
    }
}

