/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.engine.runtime.Execution;
import org.flowable.rest.service.api.runtime.process.BaseExecutionVariableResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Instance Variables"}, description="Manage Process Instances Variables", authorizations={@Authorization(value="basicAuth")})
public class ProcessInstanceVariableDataResource
extends BaseExecutionVariableResource {
    @ApiOperation(value="Get the binary data for a variable", tags={"Process Instance Variables"}, nickname="getProcessInstanceVariableData")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process instance was found and the requested variables are returned."), @ApiResponse(code=404, message="Indicates the requested task was not found or the task does not have a variable with the given name (in the given scope). Status message provides additional information.")})
    @ResponseBody
    @GetMapping(value={"/runtime/process-instances/{processInstanceId}/variables/{variableName}/data"})
    public byte[] getVariableData(@ApiParam(name="processInstanceId") @PathVariable(value="processInstanceId") String processInstanceId, @ApiParam(name="variableName") @PathVariable(value="variableName") String variableName, @RequestParam(value="scope", required=false) String scope, HttpServletRequest request, HttpServletResponse response) {
        Execution execution = this.getProcessInstanceFromRequest(processInstanceId);
        return this.getVariableDataByteArray(execution, variableName, scope, response);
    }
}

