/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.management;

import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.ManagementService;
import org.flowable.job.api.Job;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.springframework.beans.factory.annotation.Autowired;

public class JobBaseResource {
    @Autowired
    protected ManagementService managementService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    protected Job getJobById(String jobId) {
        Job job = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        this.validateJob(job, jobId);
        return job;
    }

    protected Job getTimerJobById(String jobId) {
        Job job = (Job)this.managementService.createTimerJobQuery().jobId(jobId).singleResult();
        this.validateJob(job, jobId);
        return job;
    }

    protected Job getSuspendedJobById(String jobId) {
        Job job = (Job)this.managementService.createSuspendedJobQuery().jobId(jobId).singleResult();
        this.validateJob(job, jobId);
        return job;
    }

    protected Job getDeadLetterJobById(String jobId) {
        Job job = (Job)this.managementService.createDeadLetterJobQuery().jobId(jobId).singleResult();
        this.validateJob(job, jobId);
        return job;
    }

    protected void validateJob(Job job, String jobId) {
        if (job == null) {
            throw new FlowableObjectNotFoundException("Could not find a deadletter job with id '" + jobId + "'.", Job.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessJobInfoById(job);
        }
    }
}

