/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.engine.runtime.Execution;
import org.flowable.rest.service.api.runtime.process.ExecutionActionRequest;
import org.flowable.rest.service.api.runtime.process.ExecutionBaseResource;
import org.flowable.rest.service.api.runtime.process.ExecutionChangeActivityStateRequest;
import org.flowable.rest.service.api.runtime.process.ExecutionResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Executions"}, description="Manage Executions", authorizations={@Authorization(value="basicAuth")})
public class ExecutionResource
extends ExecutionBaseResource {
    @ApiOperation(value="Get an execution", tags={"Executions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the execution was found and returned."), @ApiResponse(code=404, message="Indicates the execution was not found.")})
    @GetMapping(value={"/runtime/executions/{executionId}"}, produces={"application/json"})
    public ExecutionResponse getExecution(@ApiParam(name="executionId") @PathVariable String executionId, HttpServletRequest request) {
        return this.restResponseFactory.createExecutionResponse(this.getExecutionFromRequest(executionId));
    }

    @ApiOperation(value="Execute an action on an execution", tags={"Executions"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the execution was found and the action is performed."), @ApiResponse(code=204, message="Indicates the execution was found, the action was performed and the action caused the execution to end."), @ApiResponse(code=400, message="Indicates an illegal action was requested, required parameters are missing in the request body or illegal variables are passed in. Status description contains additional information about the error."), @ApiResponse(code=404, message="Indicates the execution was not found.")})
    @PutMapping(value={"/runtime/executions/{executionId}"}, produces={"application/json"})
    public ExecutionResponse performExecutionAction(@ApiParam(name="executionId") @PathVariable String executionId, @RequestBody ExecutionActionRequest actionRequest, HttpServletRequest request, HttpServletResponse response) {
        Execution execution = this.getExecutionFromRequest(executionId);
        if ("signal".equals(actionRequest.getAction()) || "trigger".equals(actionRequest.getAction())) {
            if (actionRequest.getTransientVariables() != null && actionRequest.getVariables() != null) {
                this.runtimeService.trigger(execution.getId(), this.getVariablesToSet(actionRequest.getVariables()), this.getVariablesToSet(actionRequest.getTransientVariables()));
            } else if (actionRequest.getVariables() != null) {
                this.runtimeService.trigger(execution.getId(), this.getVariablesToSet(actionRequest.getVariables()));
            } else {
                this.runtimeService.trigger(execution.getId());
            }
        } else if ("signalEventReceived".equals(actionRequest.getAction())) {
            if (actionRequest.getSignalName() == null) {
                throw new FlowableIllegalArgumentException("Signal name is required");
            }
            if (actionRequest.getVariables() != null) {
                this.runtimeService.signalEventReceived(actionRequest.getSignalName(), execution.getId(), this.getVariablesToSet(actionRequest.getVariables()));
            } else {
                this.runtimeService.signalEventReceived(actionRequest.getSignalName(), execution.getId());
            }
        } else if ("messageEventReceived".equals(actionRequest.getAction())) {
            if (actionRequest.getMessageName() == null) {
                throw new FlowableIllegalArgumentException("Message name is required");
            }
            if (actionRequest.getVariables() != null) {
                this.runtimeService.messageEventReceived(actionRequest.getMessageName(), execution.getId(), this.getVariablesToSet(actionRequest.getVariables()));
            } else {
                this.runtimeService.messageEventReceived(actionRequest.getMessageName(), execution.getId());
            }
        } else {
            throw new FlowableIllegalArgumentException("Invalid action: '" + actionRequest.getAction() + "'.");
        }
        execution = (Execution)this.runtimeService.createExecutionQuery().executionId(execution.getId()).singleResult();
        if (execution == null) {
            response.setStatus(HttpStatus.NO_CONTENT.value());
            return null;
        }
        return this.restResponseFactory.createExecutionResponse(execution);
    }

    @ApiOperation(value="Change the state of an execution", tags={"Executions"}, notes="")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the execution was found and the action is performed."), @ApiResponse(code=404, message="Indicates the execution was not found.")})
    @PostMapping(value={"/runtime/executions/{executionId}/change-state"}, produces={"application/json"})
    public void changeActivityState(@ApiParam(name="executionId") @PathVariable String executionId, @RequestBody ExecutionChangeActivityStateRequest activityStateRequest, HttpServletRequest request) {
        this.runtimeService.createChangeActivityStateBuilder().moveSingleExecutionToActivityIds(executionId, activityStateRequest.getStartActivityIds()).changeState();
    }
}

