/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.rest.service.api.runtime.process.ExecutionActionRequest;
import org.flowable.rest.service.api.runtime.process.ExecutionBaseResource;
import org.flowable.rest.service.api.runtime.process.ExecutionQueryRequest;
import org.flowable.rest.service.api.runtime.process.ExecutionResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Executions"}, description="Manage Executions", authorizations={@Authorization(value="basicAuth")})
public class ExecutionCollectionResource
extends ExecutionBaseResource {
    @ApiOperation(value="List of executions", tags={"Executions"}, nickname="listExecutions")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", dataType="string", value="Only return models with the given version.", paramType="query"), @ApiImplicitParam(name="activityId", dataType="string", value="Only return executions with the given activity id.", paramType="query"), @ApiImplicitParam(name="processDefinitionKey", dataType="string", value="Only return process instances with the given process definition key.", paramType="query"), @ApiImplicitParam(name="processDefinitionId", dataType="string", value="Only return process instances with the given process definition id.", paramType="query"), @ApiImplicitParam(name="processInstanceId", dataType="string", value="Only return executions which are part of the process instance with the given id.", paramType="query"), @ApiImplicitParam(name="messageEventSubscriptionName", dataType="string", value="Only return executions which are subscribed to a message with the given name.", paramType="query"), @ApiImplicitParam(name="signalEventSubscriptionName", dataType="string", value="Only return executions which are subscribed to a signal with the given name.", paramType="query"), @ApiImplicitParam(name="parentId", dataType="string", value="Only return executions which are a direct child of the given execution.", paramType="query"), @ApiImplicitParam(name="tenantId", dataType="string", value="Only return process instances with the given tenantId.", paramType="query"), @ApiImplicitParam(name="tenantIdLike", dataType="string", value="Only return process instances with a tenantId like the given value.", paramType="query"), @ApiImplicitParam(name="withoutTenantId", dataType="boolean", value="If true, only returns process instances without a tenantId set. If false, the withoutTenantId parameter is ignored.", paramType="query"), @ApiImplicitParam(name="sort", dataType="string", value="Property to sort on, to be used together with the order.", allowableValues="processInstanceId ,processDefinitionId,processDefinitionKey ,tenantId", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the executions are returned"), @ApiResponse(code=400, message="Indicates a parameter was passed in the wrong format . The status-message contains additional information.")})
    @GetMapping(value={"/runtime/executions"}, produces={"application/json"})
    public DataResponse<ExecutionResponse> getProcessInstances(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams, HttpServletRequest request) {
        ExecutionQueryRequest queryRequest = new ExecutionQueryRequest();
        if (allRequestParams.containsKey("id")) {
            queryRequest.setId(allRequestParams.get("id"));
        }
        if (allRequestParams.containsKey("processInstanceId")) {
            queryRequest.setProcessInstanceId(allRequestParams.get("processInstanceId"));
        }
        if (allRequestParams.containsKey("processInstanceBusinessKey")) {
            queryRequest.setProcessBusinessKey(allRequestParams.get("processInstanceBusinessKey"));
        }
        if (allRequestParams.containsKey("processDefinitionKey")) {
            queryRequest.setProcessDefinitionKey(allRequestParams.get("processDefinitionKey"));
        }
        if (allRequestParams.containsKey("processDefinitionId")) {
            queryRequest.setProcessDefinitionId(allRequestParams.get("processDefinitionId"));
        }
        if (allRequestParams.containsKey("messageEventSubscriptionName")) {
            queryRequest.setMessageEventSubscriptionName(allRequestParams.get("messageEventSubscriptionName"));
        }
        if (allRequestParams.containsKey("signalEventSubscriptionName")) {
            queryRequest.setSignalEventSubscriptionName(allRequestParams.get("signalEventSubscriptionName"));
        }
        if (allRequestParams.containsKey("activityId")) {
            queryRequest.setActivityId(allRequestParams.get("activityId"));
        }
        if (allRequestParams.containsKey("parentId")) {
            queryRequest.setParentId(allRequestParams.get("parentId"));
        }
        if (allRequestParams.containsKey("tenantId")) {
            queryRequest.setTenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            queryRequest.setTenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (allRequestParams.containsKey("withoutTenantId") && Boolean.valueOf(allRequestParams.get("withoutTenantId")).booleanValue()) {
            queryRequest.setWithoutTenantId(Boolean.TRUE);
        }
        return this.getQueryResponse(queryRequest, allRequestParams, request.getRequestURL().toString().replace("/runtime/executions", ""));
    }

    @ApiOperation(value="Signal event received", tags={"Executions"})
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates request was successful and the executions are returned"), @ApiResponse(code=404, message="Indicates a parameter was passed in the wrong format . The status-message contains additional information.")})
    @PutMapping(value={"/runtime/executions"})
    public void executeExecutionAction(@RequestBody ExecutionActionRequest actionRequest, HttpServletResponse response) {
        if (!"signalEventReceived".equals(actionRequest.getAction())) {
            throw new FlowableIllegalArgumentException("Illegal action: '" + actionRequest.getAction() + "'.");
        }
        if (actionRequest.getSignalName() == null) {
            throw new FlowableIllegalArgumentException("Signal name is required.");
        }
        if (actionRequest.getVariables() != null) {
            this.runtimeService.signalEventReceived(actionRequest.getSignalName(), this.getVariablesToSet(actionRequest.getVariables()));
        } else {
            this.runtimeService.signalEventReceived(actionRequest.getSignalName());
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

