/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventListener;
import org.flowable.bpmn.model.ImplementationType;
import org.flowable.bpmn.model.Process;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ProcessLevelValidator;

public class FlowableEventListenerValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List eventListeners = process.getEventListeners();
        if (eventListeners != null) {
            for (EventListener eventListener : eventListeners) {
                if (eventListener.getImplementationType() != null && eventListener.getImplementationType().equals(ImplementationType.IMPLEMENTATION_TYPE_INVALID_THROW_EVENT)) {
                    this.addError(errors, "flowable-event-listener-invalid-throw-event-type", process, (BaseElement)eventListener, "Invalid or unsupported throw event type on event listener");
                    continue;
                }
                if (eventListener.getImplementationType() == null || eventListener.getImplementationType().length() == 0) {
                    this.addError(errors, "flowable-event-listener-implementation-missing", process, (BaseElement)eventListener, "Element 'class', 'delegateExpression' or 'throwEvent' is mandatory on eventListener");
                    continue;
                }
                if (eventListener.getImplementationType() == null || ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(eventListener.getImplementationType()) || ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(eventListener.getImplementationType()) || ImplementationType.IMPLEMENTATION_TYPE_THROW_SIGNAL_EVENT.equals(eventListener.getImplementationType()) || ImplementationType.IMPLEMENTATION_TYPE_THROW_GLOBAL_SIGNAL_EVENT.equals(eventListener.getImplementationType()) || ImplementationType.IMPLEMENTATION_TYPE_THROW_MESSAGE_EVENT.equals(eventListener.getImplementationType()) || ImplementationType.IMPLEMENTATION_TYPE_THROW_ERROR_EVENT.equals(eventListener.getImplementationType())) continue;
                this.addError(errors, "flowable-event-listener-invalid-implementation", process, (BaseElement)eventListener, "Unsupported implementation type for event listener");
            }
        }
    }
}

