/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.enterprise.concurrent.ManagedThreadFactory;
import org.flowable.job.service.impl.asyncexecutor.DefaultAsyncJobExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedAsyncJobExecutor
extends DefaultAsyncJobExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedAsyncJobExecutor.class);
    protected ManagedThreadFactory threadFactory;

    public ManagedThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ManagedThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Override
    protected void initAsyncJobExecutionThreadPool() {
        if (this.threadFactory == null) {
            LOGGER.warn("A managed thread factory was not found, falling back to self-managed threads");
            super.initAsyncJobExecutionThreadPool();
        } else {
            if (this.threadPoolQueue == null) {
                LOGGER.info("Creating thread pool queue of size {}", (Object)this.queueSize);
                this.threadPoolQueue = new ArrayBlockingQueue(this.queueSize);
            }
            if (this.executorService == null) {
                LOGGER.info("Creating executor service with corePoolSize {}, maxPoolSize {} and keepAliveTime {}", new Object[]{this.corePoolSize, this.maxPoolSize, this.keepAliveTime});
                ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)this.threadPoolQueue, (ThreadFactory)this.threadFactory);
                threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                this.executorService = threadPoolExecutor;
            }
            this.startJobAcquisitionThread();
        }
    }
}

