/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.history.async;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.history.async.AsyncHistoryListener;
import org.flowable.job.service.impl.history.async.AsyncHistorySession;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.job.service.impl.util.CommandContextUtil;

public class DefaultAsyncHistoryJobProducer
implements AsyncHistoryListener {
    protected String jobTypeAsyncHistory;
    protected String jobTypeAsyncHistoryZipped;
    protected String historyJobScopeType;
    protected boolean isJsonGzipCompressionEnabled;
    protected boolean isAsyncHistoryJsonGroupingEnabled;
    protected int asyncHistoryJsonGroupingThreshold;

    public DefaultAsyncHistoryJobProducer(String jobTypeAsyncHistory, String jobTypeAsyncHistoryZipped) {
        this.jobTypeAsyncHistory = jobTypeAsyncHistory;
        this.jobTypeAsyncHistoryZipped = jobTypeAsyncHistoryZipped;
    }

    public DefaultAsyncHistoryJobProducer(String jobTypeAsyncHistory, String jobTypeAsyncHistoryZipped, String historyJobScopeType) {
        this(jobTypeAsyncHistory, jobTypeAsyncHistoryZipped);
        this.historyJobScopeType = historyJobScopeType;
    }

    @Override
    public List<HistoryJobEntity> historyDataGenerated(List<ObjectNode> historyObjectNodes) {
        List<HistoryJobEntity> historyJobEntities = this.createJobsWithHistoricalData(historyObjectNodes, Context.getCommandContext());
        this.processHistoryJobEntities(historyJobEntities);
        return historyJobEntities;
    }

    protected List<HistoryJobEntity> createJobsWithHistoricalData(List<ObjectNode> historyObjectNodes, CommandContext commandContext) {
        AsyncHistorySession asyncHistorySession = (AsyncHistorySession)commandContext.getSession(AsyncHistorySession.class);
        if (this.isAsyncHistoryJsonGroupingEnabled && historyObjectNodes.size() >= this.asyncHistoryJsonGroupingThreshold) {
            String jobType = this.isJsonGzipCompressionEnabled ? this.jobTypeAsyncHistoryZipped : this.jobTypeAsyncHistory;
            HistoryJobEntity jobEntity = this.createAndInsertJobEntity(commandContext, asyncHistorySession, jobType);
            ArrayNode arrayNode = CommandContextUtil.getJobServiceConfiguration(commandContext).getObjectMapper().createArrayNode();
            for (ObjectNode historyJsonNode : historyObjectNodes) {
                arrayNode.add((JsonNode)historyJsonNode);
            }
            this.addJsonToJob(commandContext, jobEntity, (JsonNode)arrayNode, this.isJsonGzipCompressionEnabled);
            return Collections.singletonList(jobEntity);
        }
        ArrayList<HistoryJobEntity> historyJobEntities = new ArrayList<HistoryJobEntity>(historyObjectNodes.size());
        for (ObjectNode historyJsonNode : historyObjectNodes) {
            HistoryJobEntity jobEntity = this.createAndInsertJobEntity(commandContext, asyncHistorySession, this.jobTypeAsyncHistory);
            this.addJsonToJob(commandContext, jobEntity, (JsonNode)historyJsonNode, false);
            historyJobEntities.add(jobEntity);
        }
        return historyJobEntities;
    }

    protected HistoryJobEntity createAndInsertJobEntity(CommandContext commandContext, AsyncHistorySession asyncHistorySession, String jobType) {
        JobServiceConfiguration jobServiceConfiguration = CommandContextUtil.getJobServiceConfiguration(commandContext);
        HistoryJobEntity currentJobEntity = (HistoryJobEntity)jobServiceConfiguration.getHistoryJobEntityManager().create();
        currentJobEntity.setJobHandlerType(jobType);
        currentJobEntity.setRetries(jobServiceConfiguration.getAsyncHistoryExecutorNumberOfRetries());
        currentJobEntity.setTenantId(asyncHistorySession.getTenantId());
        currentJobEntity.setCreateTime(jobServiceConfiguration.getClock().getCurrentTime());
        currentJobEntity.setScopeType(this.historyJobScopeType);
        CommandContextUtil.getJobManager(commandContext).scheduleHistoryJob(currentJobEntity);
        return currentJobEntity;
    }

    protected void addJsonToJob(CommandContext commandContext, HistoryJobEntity jobEntity, JsonNode rootObjectNode, boolean applyCompression) {
        try {
            byte[] bytes = CommandContextUtil.getJobServiceConfiguration(commandContext).getObjectMapper().writeValueAsBytes((Object)rootObjectNode);
            if (applyCompression) {
                bytes = this.compress(bytes);
            }
            jobEntity.setAdvancedJobHandlerConfigurationBytes(bytes);
        }
        catch (JsonProcessingException e) {
            throw new FlowableException("Could not serialize historic data for async history", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] compress(byte[] bytes) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (GZIPOutputStream gos = new GZIPOutputStream(baos);){
                gos.write(bytes);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new FlowableException("Error while compressing json", (Throwable)e);
        }
    }

    protected void processHistoryJobEntities(List<HistoryJobEntity> historyJobEntities) {
    }

    public boolean isJsonGzipCompressionEnabled() {
        return this.isJsonGzipCompressionEnabled;
    }

    public void setJsonGzipCompressionEnabled(boolean isJsonGzipCompressionEnabled) {
        this.isJsonGzipCompressionEnabled = isJsonGzipCompressionEnabled;
    }

    public boolean isAsyncHistoryJsonGroupingEnabled() {
        return this.isAsyncHistoryJsonGroupingEnabled;
    }

    public void setAsyncHistoryJsonGroupingEnabled(boolean isAsyncHistoryJsonGroupingEnabled) {
        this.isAsyncHistoryJsonGroupingEnabled = isAsyncHistoryJsonGroupingEnabled;
    }

    public int getAsyncHistoryJsonGroupingThreshold() {
        return this.asyncHistoryJsonGroupingThreshold;
    }

    public void setAsyncHistoryJsonGroupingThreshold(int asyncHistoryJsonGroupingThreshold) {
        this.asyncHistoryJsonGroupingThreshold = asyncHistoryJsonGroupingThreshold;
    }
}

