/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.history.async;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.job.service.impl.history.async.AsyncHistoryListener;
import org.flowable.job.service.impl.history.async.AsyncHistorySession;
import org.flowable.job.service.impl.util.CommandContextUtil;

public class AsyncHistorySessionCommandContextCloseListener
implements CommandContextCloseListener {
    protected AsyncHistorySession asyncHistorySession;
    protected AsyncHistoryListener asyncHistoryListener;
    protected String typeFieldName = "type";
    protected String dataFieldName = "data";

    public AsyncHistorySessionCommandContextCloseListener() {
    }

    public AsyncHistorySessionCommandContextCloseListener(AsyncHistorySession asyncHistorySession, AsyncHistoryListener asyncHistoryListener) {
        this.asyncHistorySession = asyncHistorySession;
        this.asyncHistoryListener = asyncHistoryListener;
    }

    public void closing(CommandContext commandContext) {
        Map<String, List<Map<String, String>>> jobData = this.asyncHistorySession.getJobData();
        if (!jobData.isEmpty()) {
            ArrayList<ObjectNode> objectNodes = new ArrayList<ObjectNode>();
            for (String type : this.asyncHistorySession.getJobDataTypes()) {
                if (!jobData.containsKey(type)) continue;
                this.generateJson(commandContext, jobData, objectNodes, type);
                jobData.remove(type);
            }
            if (!jobData.isEmpty()) {
                for (String type : jobData.keySet()) {
                    this.generateJson(commandContext, jobData, objectNodes, type);
                }
            }
            this.asyncHistoryListener.historyDataGenerated(objectNodes);
        }
    }

    protected void generateJson(CommandContext commandContext, Map<String, List<Map<String, String>>> jobData, List<ObjectNode> objectNodes, String type) {
        List<Map<String, String>> historicDataList = jobData.get(type);
        for (Map<String, String> historicData : historicDataList) {
            ObjectNode historyJson = this.generateJson(commandContext, type, historicData);
            objectNodes.add(historyJson);
        }
    }

    protected ObjectNode generateJson(CommandContext commandContext, String type, Map<String, String> historicData) {
        ObjectNode elementObjectNode = CommandContextUtil.getJobServiceConfiguration(commandContext).getObjectMapper().createObjectNode();
        elementObjectNode.put(this.typeFieldName, type);
        ObjectNode dataNode = elementObjectNode.putObject(this.dataFieldName);
        for (String key : historicData.keySet()) {
            dataNode.put(key, historicData.get(key));
        }
        return elementObjectNode;
    }

    public void closed(CommandContext commandContext) {
    }

    public void closeFailure(CommandContext commandContext) {
    }

    public void afterSessionsFlush(CommandContext commandContext) {
    }

    public AsyncHistorySession getAsyncHistorySession() {
        return this.asyncHistorySession;
    }

    public void setAsyncHistorySession(AsyncHistorySession asyncHistorySession) {
        this.asyncHistorySession = asyncHistorySession;
    }

    public AsyncHistoryListener getAsyncHistoryListener() {
        return this.asyncHistoryListener;
    }

    public void setAsyncHistoryListener(AsyncHistoryListener asyncHistoryListener) {
        this.asyncHistoryListener = asyncHistoryListener;
    }

    public String getTypeFieldName() {
        return this.typeFieldName;
    }

    public void setTypeFieldName(String typeFieldName) {
        this.typeFieldName = typeFieldName;
    }

    public String getDataFieldName() {
        return this.dataFieldName;
    }

    public void setDataFieldName(String dataFieldName) {
        this.dataFieldName = dataFieldName;
    }
}

