/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.persistence.entity.AbstractEntity;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobByteArrayRef;

public class HistoryJobEntityImpl
extends AbstractEntity
implements HistoryJobEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int retries;
    protected String jobHandlerType;
    protected String jobHandlerConfiguration;
    protected JobByteArrayRef advancedJobHandlerConfigurationByteArrayRef;
    protected JobByteArrayRef exceptionByteArrayRef;
    protected String exceptionMessage;
    protected String tenantId = "";
    protected String lockOwner;
    protected Date lockExpirationTime;
    protected Date createTime;

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("retries", this.retries);
        persistentState.put("exceptionMessage", this.exceptionMessage);
        persistentState.put("jobHandlerType", this.jobHandlerType);
        if (this.exceptionByteArrayRef != null) {
            persistentState.put("exceptionByteArrayId", this.exceptionByteArrayRef.getId());
        }
        if (this.advancedJobHandlerConfigurationByteArrayRef != null) {
            persistentState.put("advancedJobHandlerConfigurationByteArrayRef", this.advancedJobHandlerConfigurationByteArrayRef.getId());
        }
        persistentState.put("lockOwner", this.lockOwner);
        persistentState.put("lockExpirationTime", this.lockExpirationTime);
        return persistentState;
    }

    public int getRetries() {
        return this.retries;
    }

    @Override
    public void setRetries(int retries) {
        this.retries = retries;
    }

    public String getJobHandlerType() {
        return this.jobHandlerType;
    }

    @Override
    public void setJobHandlerType(String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
    }

    public String getJobHandlerConfiguration() {
        return this.jobHandlerConfiguration;
    }

    @Override
    public void setJobHandlerConfiguration(String jobHandlerConfiguration) {
        this.jobHandlerConfiguration = jobHandlerConfiguration;
    }

    @Override
    public JobByteArrayRef getAdvancedJobHandlerConfigurationByteArrayRef() {
        return this.advancedJobHandlerConfigurationByteArrayRef;
    }

    @Override
    public String getAdvancedJobHandlerConfiguration() {
        if (this.advancedJobHandlerConfigurationByteArrayRef == null) {
            return null;
        }
        byte[] bytes = this.advancedJobHandlerConfigurationByteArrayRef.getBytes();
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new FlowableException("UTF-8 is not a supported encoding");
        }
    }

    @Override
    public void setAdvancedJobHandlerConfigurationByteArrayRef(JobByteArrayRef configurationByteArrayRef) {
        this.advancedJobHandlerConfigurationByteArrayRef = configurationByteArrayRef;
    }

    @Override
    public void setAdvancedJobHandlerConfiguration(String jobHandlerConfiguration) {
        if (this.advancedJobHandlerConfigurationByteArrayRef == null) {
            this.advancedJobHandlerConfigurationByteArrayRef = new JobByteArrayRef();
        }
        this.advancedJobHandlerConfigurationByteArrayRef.setValue("cfg", this.getUtf8Bytes(jobHandlerConfiguration));
    }

    @Override
    public void setAdvancedJobHandlerConfigurationBytes(byte[] bytes) {
        if (this.advancedJobHandlerConfigurationByteArrayRef == null) {
            this.advancedJobHandlerConfigurationByteArrayRef = new JobByteArrayRef();
        }
        this.advancedJobHandlerConfigurationByteArrayRef.setValue("cfg", bytes);
    }

    @Override
    public void setExceptionByteArrayRef(JobByteArrayRef exceptionByteArrayRef) {
        this.exceptionByteArrayRef = exceptionByteArrayRef;
    }

    @Override
    public JobByteArrayRef getExceptionByteArrayRef() {
        return this.exceptionByteArrayRef;
    }

    @Override
    public String getExceptionStacktrace() {
        if (this.exceptionByteArrayRef == null) {
            return null;
        }
        byte[] bytes = this.exceptionByteArrayRef.getBytes();
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new FlowableException("UTF-8 is not a supported encoding");
        }
    }

    @Override
    public void setExceptionStacktrace(String exception) {
        if (this.exceptionByteArrayRef == null) {
            this.exceptionByteArrayRef = new JobByteArrayRef();
        }
        this.exceptionByteArrayRef.setValue("stacktrace", this.getUtf8Bytes(exception));
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = StringUtils.abbreviate((String)exceptionMessage, (int)255);
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getLockOwner() {
        return this.lockOwner;
    }

    @Override
    public void setLockOwner(String claimedBy) {
        this.lockOwner = claimedBy;
    }

    @Override
    public Date getLockExpirationTime() {
        return this.lockExpirationTime;
    }

    @Override
    public void setLockExpirationTime(Date claimedUntil) {
        this.lockExpirationTime = claimedUntil;
    }

    protected byte[] getUtf8Bytes(String str) {
        if (str == null) {
            return null;
        }
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new FlowableException("UTF-8 is not a supported encoding");
        }
    }

    public String toString() {
        return "HistoryJobEntity [id=" + this.id + "]";
    }
}

