/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.executor.jms;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.flowable.engine.impl.asyncexecutor.ExecuteAsyncRunnable;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.JobInfoEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMessageListener
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobMessageListener.class);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public void onMessage(Message message) {
        try {
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                String jobId = textMessage.getText();
                ExecuteAsyncRunnable executeAsyncRunnable = new ExecuteAsyncRunnable(jobId, this.processEngineConfiguration, (JobInfoEntityManager)this.processEngineConfiguration.getJobEntityManager(), null);
                executeAsyncRunnable.run();
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception when handling message from job queue", (Throwable)e);
        }
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }
}

