/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.executor.jms;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.flowable.engine.impl.asyncexecutor.AsyncRunnableExecutionExceptionHandler;
import org.flowable.engine.impl.asyncexecutor.ExecuteAsyncRunnable;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.async.UnacquireAsyncHistoryJobExceptionHandler;
import org.flowable.engine.impl.persistence.entity.JobInfoEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoryJobMessageListener
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(HistoryJobMessageListener.class);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected AsyncRunnableExecutionExceptionHandler exceptionHandler = new UnacquireAsyncHistoryJobExceptionHandler();

    public void onMessage(Message message) {
        try {
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                String jobId = textMessage.getText();
                ExecuteAsyncRunnable executeAsyncRunnable = new ExecuteAsyncRunnable(jobId, this.processEngineConfiguration, (JobInfoEntityManager)this.processEngineConfiguration.getHistoryJobEntityManager(), this.exceptionHandler);
                executeAsyncRunnable.run();
            }
        }
        catch (Exception e) {
            logger.error("Exception when handling message from job queue", (Throwable)e);
        }
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }
}

