/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.persistence.entity;

import java.io.Serializable;
import org.flowable.idm.engine.impl.persistence.entity.ByteArrayEntityManager;
import org.flowable.idm.engine.impl.persistence.entity.IdmByteArrayEntity;
import org.flowable.idm.engine.impl.util.CommandContextUtil;

public class ByteArrayRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private IdmByteArrayEntity entity;
    protected boolean deleted;

    public ByteArrayRef() {
    }

    public ByteArrayRef(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBytes() {
        this.ensureInitialized();
        return this.entity != null ? this.entity.getBytes() : null;
    }

    public void setValue(String name, byte[] bytes) {
        this.name = name;
        this.setBytes(bytes);
    }

    private void setBytes(byte[] bytes) {
        if (this.id == null) {
            if (bytes != null) {
                ByteArrayEntityManager byteArrayEntityManager = CommandContextUtil.getByteArrayEntityManager();
                this.entity = (IdmByteArrayEntity)byteArrayEntityManager.create();
                this.entity.setName(this.name);
                this.entity.setBytes(bytes);
                byteArrayEntityManager.insert(this.entity);
                this.id = this.entity.getId();
            }
        } else {
            this.ensureInitialized();
            this.entity.setBytes(bytes);
        }
    }

    public IdmByteArrayEntity getEntity() {
        this.ensureInitialized();
        return this.entity;
    }

    public void delete() {
        if (!this.deleted && this.id != null) {
            if (this.entity != null) {
                CommandContextUtil.getByteArrayEntityManager().delete(this.entity);
            } else {
                CommandContextUtil.getByteArrayEntityManager().deleteByteArrayById(this.id);
            }
            this.entity = null;
            this.id = null;
            this.deleted = true;
        }
    }

    private void ensureInitialized() {
        if (this.id != null && this.entity == null) {
            this.entity = (IdmByteArrayEntity)CommandContextUtil.getByteArrayEntityManager().findById(this.id);
            this.name = this.entity.getName();
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String toString() {
        return "ByteArrayRef[id=" + this.id + ", name=" + this.name + ", entity=" + this.entity + (this.deleted ? ", deleted]" : "]");
    }
}

