/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.test;

import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.IdmEngines;
import org.flowable.idm.engine.test.AbstractFlowableIdmTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceFlowableIdmTestCase
extends AbstractFlowableIdmTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceFlowableIdmTestCase.class);
    protected String idmConfigurationResource;
    protected String idmEngineName;

    public ResourceFlowableIdmTestCase(String idmConfigurationResource) {
        this(idmConfigurationResource, null);
    }

    public ResourceFlowableIdmTestCase(String idmConfigurationResource, String idmEngineName) {
        this.idmConfigurationResource = idmConfigurationResource;
        this.idmEngineName = idmEngineName;
    }

    @Override
    protected void closeDownIdmEngine() {
        super.closeDownIdmEngine();
        IdmEngines.unregister(this.idmEngine);
        this.idmEngine = null;
    }

    @Override
    protected void initializeIdmEngine() {
        IdmEngineConfiguration config = IdmEngineConfiguration.createIdmEngineConfigurationFromResource(this.idmConfigurationResource);
        if (this.idmEngineName != null) {
            LOGGER.info("Initializing idm engine with name '{}'", (Object)this.idmEngineName);
            config.setEngineName(this.idmEngineName);
        }
        this.additionalConfiguration(config);
        this.idmEngine = config.buildIdmEngine();
    }

    protected void additionalConfiguration(IdmEngineConfiguration idmEngineConfiguration) {
    }
}

