/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.idm.api.Picture;
import org.flowable.idm.api.User;
import org.flowable.idm.engine.impl.util.CommandContextUtil;

public class GetUserPictureCmd
implements Command<Picture>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String userId;

    public GetUserPictureCmd(String userId) {
        this.userId = userId;
    }

    public Picture execute(CommandContext commandContext) {
        if (this.userId == null) {
            throw new FlowableIllegalArgumentException("userId is null");
        }
        User user = (User)CommandContextUtil.getIdmEngineConfiguration().getIdmIdentityService().createUserQuery().userId(this.userId).singleResult();
        if (user == null) {
            throw new FlowableObjectNotFoundException("user " + this.userId + " doesn't exist", User.class);
        }
        return CommandContextUtil.getUserEntityManager(commandContext).getUserPicture(user);
    }
}

