/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.db;

import java.util.Collections;
import java.util.List;

public class FlowableIdmVersion {
    protected String mainVersion;
    protected List<String> alternativeVersionStrings;

    public FlowableIdmVersion(String mainVersion) {
        this.mainVersion = mainVersion;
        this.alternativeVersionStrings = Collections.singletonList(mainVersion);
    }

    public FlowableIdmVersion(String mainVersion, List<String> alternativeVersionStrings) {
        this.mainVersion = mainVersion;
        this.alternativeVersionStrings = alternativeVersionStrings;
    }

    public String getMainVersion() {
        return this.mainVersion;
    }

    public boolean matches(String version) {
        if (version.equals(this.mainVersion)) {
            return true;
        }
        if (!this.alternativeVersionStrings.isEmpty()) {
            return this.alternativeVersionStrings.contains(version);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FlowableIdmVersion)) {
            return false;
        }
        FlowableIdmVersion other = (FlowableIdmVersion)obj;
        boolean mainVersionEqual = this.mainVersion.equals(other.mainVersion);
        if (!mainVersionEqual) {
            return false;
        }
        if (this.alternativeVersionStrings != null) {
            return this.alternativeVersionStrings.equals(other.alternativeVersionStrings);
        }
        return other.alternativeVersionStrings == null;
    }
}

