/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.identitylink.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.flowable.common.engine.impl.AbstractServiceConfiguration;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.identitylink.service.HistoricIdentityLinkService;
import org.flowable.identitylink.service.IdentityLinkService;
import org.flowable.identitylink.service.impl.HistoricIdentityLinkServiceImpl;
import org.flowable.identitylink.service.impl.IdentityLinkServiceImpl;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntityManager;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntityManagerImpl;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntityManager;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntityManagerImpl;
import org.flowable.identitylink.service.impl.persistence.entity.data.HistoricIdentityLinkDataManager;
import org.flowable.identitylink.service.impl.persistence.entity.data.IdentityLinkDataManager;
import org.flowable.identitylink.service.impl.persistence.entity.data.impl.MybatisHistoricIdentityLinkDataManager;
import org.flowable.identitylink.service.impl.persistence.entity.data.impl.MybatisIdentityLinkDataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityLinkServiceConfiguration
extends AbstractServiceConfiguration {
    protected static final Logger LOGGER = LoggerFactory.getLogger(IdentityLinkServiceConfiguration.class);
    protected IdentityLinkService identityLinkService = new IdentityLinkServiceImpl(this);
    protected HistoricIdentityLinkService historicIdentityLinkService = new HistoricIdentityLinkServiceImpl(this);
    protected IdentityLinkDataManager identityLinkDataManager;
    protected HistoricIdentityLinkDataManager historicIdentityLinkDataManager;
    protected IdentityLinkEntityManager identityLinkEntityManager;
    protected HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager;
    protected HistoryLevel historyLevel;
    protected ObjectMapper objectMapper;

    public void init() {
        this.initDataManagers();
        this.initEntityManagers();
    }

    public boolean isHistoryLevelAtLeast(HistoryLevel level) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current history level: {}, level required: {}", (Object)this.historyLevel, (Object)level);
        }
        return this.historyLevel.isAtLeast(level);
    }

    public boolean isHistoryEnabled() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current history level: {}", (Object)this.historyLevel);
        }
        return this.historyLevel != HistoryLevel.NONE;
    }

    public void initDataManagers() {
        if (this.identityLinkDataManager == null) {
            this.identityLinkDataManager = new MybatisIdentityLinkDataManager();
        }
        if (this.historicIdentityLinkDataManager == null) {
            this.historicIdentityLinkDataManager = new MybatisHistoricIdentityLinkDataManager();
        }
    }

    public void initEntityManagers() {
        if (this.identityLinkEntityManager == null) {
            this.identityLinkEntityManager = new IdentityLinkEntityManagerImpl(this, this.identityLinkDataManager);
        }
        if (this.historicIdentityLinkEntityManager == null) {
            this.historicIdentityLinkEntityManager = new HistoricIdentityLinkEntityManagerImpl(this, this.historicIdentityLinkDataManager);
        }
    }

    public IdentityLinkServiceConfiguration getIdentityLinkServiceConfiguration() {
        return this;
    }

    public IdentityLinkService getIdentityLinkService() {
        return this.identityLinkService;
    }

    public IdentityLinkServiceConfiguration setIdentityLinkService(IdentityLinkService identityLinkService) {
        this.identityLinkService = identityLinkService;
        return this;
    }

    public HistoricIdentityLinkService getHistoricIdentityLinkService() {
        return this.historicIdentityLinkService;
    }

    public IdentityLinkServiceConfiguration setHistoricIdentityLinkService(HistoricIdentityLinkService historicIdentityLinkService) {
        this.historicIdentityLinkService = historicIdentityLinkService;
        return this;
    }

    public IdentityLinkDataManager getIdentityLinkDataManager() {
        return this.identityLinkDataManager;
    }

    public IdentityLinkServiceConfiguration setIdentityLinkDataManager(IdentityLinkDataManager identityLinkDataManager) {
        this.identityLinkDataManager = identityLinkDataManager;
        return this;
    }

    public HistoricIdentityLinkDataManager getHistoricIdentityLinkDataManager() {
        return this.historicIdentityLinkDataManager;
    }

    public IdentityLinkServiceConfiguration setHistoricIdentityLinkDataManager(HistoricIdentityLinkDataManager historicIdentityLinkDataManager) {
        this.historicIdentityLinkDataManager = historicIdentityLinkDataManager;
        return this;
    }

    public IdentityLinkEntityManager getIdentityLinkEntityManager() {
        return this.identityLinkEntityManager;
    }

    public IdentityLinkServiceConfiguration setIdentityLinkEntityManager(IdentityLinkEntityManager identityLinkEntityManager) {
        this.identityLinkEntityManager = identityLinkEntityManager;
        return this;
    }

    public HistoricIdentityLinkEntityManager getHistoricIdentityLinkEntityManager() {
        return this.historicIdentityLinkEntityManager;
    }

    public IdentityLinkServiceConfiguration setHistoricIdentityLinkEntityManager(HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager) {
        this.historicIdentityLinkEntityManager = historicIdentityLinkEntityManager;
        return this;
    }

    public HistoryLevel getHistoryLevel() {
        return this.historyLevel;
    }

    public IdentityLinkServiceConfiguration setHistoryLevel(HistoryLevel historyLevel) {
        this.historyLevel = historyLevel;
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public IdentityLinkServiceConfiguration setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }
}

